/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ComputedValueTest
extends AbstractDefaultRealmTestCase {
    public void testValueType() throws Exception {
        ComputedValue cv = new ComputedValue(Integer.TYPE){

            protected Object calculate() {
                return new Integer(42);
            }
        };
        ComputedValueTest.assertEquals((String)"value type should be the type that was set", Integer.TYPE, (Object)cv.getValueType());
        cv = new ComputedValue(){

            protected Object calculate() {
                return null;
            }
        };
        ComputedValueTest.assertNull((Object)cv.getValueType());
    }

    public void test_getValue() throws Exception {
        ComputedValue cv = new ComputedValue(){

            protected Object calculate() {
                return new Integer(42);
            }
        };
        ComputedValueTest.assertEquals((String)"Calculated value should be 42", (Object)new Integer(42), (Object)cv.getValue());
    }

    public void testDependencyValueChange() throws Exception {
        final WritableValue value = new WritableValue((Object)new Integer(42), Integer.TYPE);
        ComputedValue cv = new ComputedValue(){

            protected Object calculate() {
                return value.getValue();
            }
        };
        ComputedValueTest.assertEquals((String)"calculated value should have been that of the writable value", (Object)value.getValue(), (Object)cv.getValue());
        value.setValue((Object)new Integer(44));
        ComputedValueTest.assertEquals((String)"calculated value should have been that of the writable value", (Object)value.getValue(), (Object)cv.getValue());
    }

    public void testHookAndUnhookDependantObservables() throws Exception {
        final ArrayList<WritableValueExt> values = new ArrayList<WritableValueExt>();
        ComputedValue cv = new ComputedValue(){

            protected Object calculate() {
                int sum = 0;
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    WritableValue value = (WritableValue)it.next();
                    sum += ((Integer)value.getValue()).intValue();
                }
                return new Integer(sum);
            }
        };
        WritableValueExt value1 = new WritableValueExt(Integer.TYPE, new Integer(1));
        WritableValueExt value2 = new WritableValueExt(Integer.TYPE, new Integer(1));
        values.add(value1);
        values.add(value2);
        ComputedValueTest.assertFalse((boolean)value1.hasListeners());
        ComputedValueTest.assertFalse((boolean)value2.hasListeners());
        cv.getValue();
        ComputedValueTest.assertTrue((boolean)value1.hasListeners());
        ComputedValueTest.assertTrue((boolean)value2.hasListeners());
        value2.setValue(new Integer(2));
        values.remove((Object)value2);
        cv.getValue();
        ComputedValueTest.assertEquals((Object)new Integer(1), (Object)cv.getValue());
        ComputedValueTest.assertTrue((boolean)value1.hasListeners());
        ComputedValueTest.assertFalse((String)"because value2 is not a part of the calculation the listeners should have been removed", (boolean)value2.hasListeners());
    }

    public void testSetValueUnsupportedOperationException() throws Exception {
        ComputedValue cv = new ComputedValue(){

            protected Object calculate() {
                return null;
            }
        };
        try {
            cv.setValue(new Object());
            ComputedValueTest.fail((String)"exception should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    private static class WritableValueExt
    extends WritableValue {
        public WritableValueExt(Object valueType, Object initialValue) {
            super(initialValue, valueType);
        }

        public boolean hasListeners() {
            return super.hasListeners();
        }
    }
}

