/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.DuplexingObservableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DuplexingObservableValueTest
extends AbstractDefaultRealmTestCase {
    private IObservableList list;
    private DuplexingObservableValue observable;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.list = new WritableList(arrayList, (Object)clazz);
    }

    public void testValueType_InheritFromTargetList() throws Exception {
        this.observable = new DuplexingObservableValue(this.list){

            protected Object coalesceElements(Collection elements) {
                return null;
            }
        };
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DuplexingObservableValueTest.assertEquals((String)"value type should be the element type of the target list", (Object)clazz, (Object)this.observable.getValueType());
    }

    public void testValueType_ProvidedInConstructor() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.observable = new DuplexingObservableValue(this.list, clazz){

            protected Object coalesceElements(Collection elements) {
                return null;
            }
        };
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DuplexingObservableValueTest.assertEquals((String)"value type should be the type passed to constructor", (Object)clazz2, (Object)this.observable.getValueType());
    }

    public void test_getValue() throws Exception {
        this.observable = DuplexingObservableValue.withDefaults((IObservableList)this.list, null, (Object)"<Multiple Values>");
        DuplexingObservableValueTest.assertNull((Object)this.observable.getValue());
        this.list.add((Object)"42");
        DuplexingObservableValueTest.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.add((Object)"42");
        DuplexingObservableValueTest.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.add((Object)"watermelon");
        DuplexingObservableValueTest.assertEquals((Object)"<Multiple Values>", (Object)this.observable.getValue());
        this.list.remove(2);
        DuplexingObservableValueTest.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.clear();
        DuplexingObservableValueTest.assertNull((Object)this.observable.getValue());
    }
}

