/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PolicyTest
extends TestCase {
    public void testConstructor() {
        new Policy();
    }

    public void testDummyLog() {
        ILogger oldLog = Policy.getLog();
        PrintStream oldErr = System.err;
        try {
            Policy.setLog(null);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            System.setErr(ps);
            Status status = new Status(8, "somePluginId", "someMessage", (Throwable)new RuntimeException());
            Policy.getLog().log((IStatus)status);
            ps.flush();
            String message = new String(os.toByteArray());
            System.out.println("testDummyLog message: " + message);
            PolicyTest.assertTrue((String)"expecting severity", (message.indexOf("CANCEL") != -1 ? 1 : 0) != 0);
            PolicyTest.assertTrue((String)"expecting plugin id", (message.indexOf("somePluginId") != -1 ? 1 : 0) != 0);
            PolicyTest.assertTrue((String)"expecting message", (message.indexOf("someMessage") != -1 ? 1 : 0) != 0);
            PolicyTest.assertTrue((String)"expecting RuntimeException", (message.indexOf("RuntimeException") != -1 ? 1 : 0) != 0);
        }
        finally {
            Policy.setLog((ILogger)oldLog);
            System.setErr(oldErr);
        }
    }

    public void testCustomLog() {
        ILogger oldLog = Policy.getLog();
        try {
            final IStatus[] statusHolder = new IStatus[1];
            Policy.setLog((ILogger)new ILogger(){

                public void log(IStatus status) {
                    statusHolder[0] = status;
                }
            });
            Status status = new Status(8, "somePluginId", "someMessage", (Throwable)new RuntimeException());
            Policy.getLog().log((IStatus)status);
            PolicyTest.assertEquals((Object)status, (Object)statusHolder[0]);
        }
        finally {
            Policy.setLog((ILogger)oldLog);
        }
    }
}

