/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.validation;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.validation.ValidatedObservableValue;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.databinding.validation.MultiValidatorTest;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class MultiValidatorTest
extends AbstractDefaultRealmTestCase {
    private DependencyObservableValue dependency;
    private MultiValidator validator;
    private IObservableValue validationStatus;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.dependency = new DependencyObservableValue(null, clazz);
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                return (IStatus)MultiValidatorTest.this.dependency.getValue();
            }
        };
        this.validationStatus = this.validator.getValidationStatus();
    }

    public void testConstructor_NullArgument() {
        try {
            new MultiValidator(null){

                protected IStatus validate() {
                    return null;
                }
            };
            MultiValidatorTest.fail((String)"Expected AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testGetValidationStatus_NullResultYieldsOKStatus() {
        IStatus status = (IStatus)this.validationStatus.getValue();
        MultiValidatorTest.assertTrue((boolean)status.isOK());
    }

    public void testGetValidationStatus_ExceptionThrownYieldsErrorStatus() {
        final RuntimeException e = new RuntimeException("message");
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                throw e;
            }
        };
        MultiValidatorTest.assertEquals((Object)ValidationStatus.error((String)"message", (Throwable)e), (Object)this.validator.getValidationStatus().getValue());
    }

    public void testGetValidationStatus_TracksWithDependency() {
        IStatus newStatus = ValidationStatus.error((String)"error");
        this.dependency.setValue(newStatus);
        MultiValidatorTest.assertEquals((Object)newStatus, (Object)this.validationStatus.getValue());
    }

    public void testInit_AddsValidationProducer() {
        DataBindingContext dbc = new DataBindingContext();
        dbc.addValidationStatusProvider((ValidationStatusProvider)this.validator);
        MultiValidatorTest.assertTrue((boolean)dbc.getValidationStatusProviders().contains((Object)this.validator));
    }

    public void testObserveValidatedValue_NullArgument() {
        try {
            this.validator.observeValidatedValue(null);
            MultiValidatorTest.fail((String)"Expected AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testObserveValidatedValue_WrongRealm() {
        CurrentRealm otherRealm = new CurrentRealm(true);
        try {
            this.validator.observeValidatedValue((IObservableValue)new WritableValue((Realm)otherRealm));
            MultiValidatorTest.fail((String)"Expected AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testObserveValidatedValue_ReturnValue() {
        WritableValue target = new WritableValue();
        ValidatedObservableValue validated = (ValidatedObservableValue)this.validator.observeValidatedValue((IObservableValue)target);
        target.setValue(new Object());
        MultiValidatorTest.assertEquals((Object)target.getValue(), (Object)validated.getValue());
        this.dependency.setValue(ValidationStatus.error((String)"error"));
        MultiValidatorTest.assertFalse((boolean)validated.isStale());
        target.setValue(new Object());
        MultiValidatorTest.assertTrue((boolean)validated.isStale());
        MultiValidatorTest.assertFalse((boolean)target.getValue().equals(validated.getValue()));
        this.dependency.setValue(ValidationStatus.info((String)"info"));
        MultiValidatorTest.assertEquals((Object)target.getValue(), (Object)validated.getValue());
        MultiValidatorTest.assertFalse((boolean)validated.isStale());
    }

    public void testBug237884_DisposeCausesNPE() {
        MultiValidator validator = new MultiValidator(){

            protected IStatus validate() {
                return ValidationStatus.ok();
            }
        };
        try {
            validator.dispose();
        }
        catch (NullPointerException nullPointerException) {
            MultiValidatorTest.fail((String)"Bug 237884: MultiValidator.dispose() causes NPE");
        }
    }

    public void testBug237884_MultipleDispose() {
        this.validator.dispose();
        this.validator.dispose();
    }

    public void testBug237884_Comment3_ValidationStatusAsDependencyCausesStackOverflow() {
        Object object = new Object();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.dependency = new DependencyObservableValue(object, clazz);
        this.validator = new MultiValidator(){
            private int counter;

            protected IStatus validate() {
                ObservableTracker.getterCalled((IObservable)MultiValidatorTest.this.dependency);
                return ValidationStatus.info((String)("info " + this.counter++));
            }
        };
        this.validationStatus = this.validator.getValidationStatus();
        this.validationStatus.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ObservableTracker.getterCalled((IObservable)MultiValidatorTest.this.validationStatus);
            }
        });
        this.dependency.setValue(new Object());
        try {
            this.dependency.setValue(new Object());
        }
        catch (StackOverflowError stackOverflowError) {
            MultiValidatorTest.fail((String)"Bug 237884: Accessing MultiValidator validation status from within listener causes infinite recursion");
        }
    }

    public void testBug237884_ValidationStatusListenerCausesLoopingDependency() {
        this.validationStatus.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ObservableTracker.getterCalled((IObservable)MultiValidatorTest.this.validationStatus);
            }
        });
        MultiValidatorTest.assertFalse((boolean)this.validator.getTargets().contains((Object)this.validationStatus));
        this.dependency.setValue(ValidationStatus.info((String)"info"));
        MultiValidatorTest.assertFalse((boolean)this.validator.getTargets().contains((Object)this.validationStatus));
    }

    public void testRevalidate() {
        IStatus[] status = new IStatus[]{ValidationStatus.ok()};
        class MyMultiValidator
        extends MultiValidator {
            final /* synthetic */ MultiValidatorTest this$0;
            private final /* synthetic */ IStatus[] val$status;

            MyMultiValidator(MultiValidatorTest multiValidatorTest, IStatus[] iStatusArray) {
                this.this$0 = multiValidatorTest;
                this.val$status = iStatusArray;
            }

            protected IStatus validate() {
                return this.val$status[0];
            }

            protected void callRevalidate() {
                this.revalidate();
            }
        }
        MyMultiValidator validator = new MyMultiValidator(this, status);
        MultiValidatorTest.assertSame((Object)status[0], (Object)validator.getValidationStatus().getValue());
        status[0] = ValidationStatus.error((String)"");
        MultiValidatorTest.assertNotSame((Object)status[0], (Object)validator.getValidationStatus().getValue());
        validator.callRevalidate();
        MultiValidatorTest.assertSame((Object)status[0], (Object)validator.getValidationStatus().getValue());
    }

    public void testBug237884_ValidationStatusAccessDuringValidationCausesLoopingDependency() {
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                ObservableTracker.getterCalled((IObservable)this.getValidationStatus());
                return (IStatus)MultiValidatorTest.this.dependency.getValue();
            }
        };
        this.dependency.setValue(ValidationStatus.info((String)"info"));
        MultiValidatorTest.assertFalse((boolean)this.validator.getTargets().contains((Object)this.validationStatus));
    }

    public void testBug240590_ValidationStatusSetWhileTrackingDependencies() {
        WritableValue noDependency = new WritableValue();
        this.validationStatus.addValueChangeListener(new IValueChangeListener((IObservableValue)noDependency){
            private final /* synthetic */ IObservableValue val$noDependency;
            {
                this.val$noDependency = iObservableValue;
            }

            public void handleValueChange(ValueChangeEvent event) {
                ObservableTracker.getterCalled((IObservable)this.val$noDependency);
            }
        });
        this.dependency.setValue(ValidationStatus.error((String)"new error"));
        MultiValidatorTest.assertFalse((boolean)this.validator.getTargets().contains((Object)noDependency));
    }

    public void testValidationStaleness() {
        ValueChangeEventTracker validationChangeCounter = ValueChangeEventTracker.observe((IObservableValue)this.validationStatus);
        StaleEventTracker validationStaleCounter = StaleEventTracker.observe((IObservable)this.validationStatus);
        MultiValidatorTest.assertFalse((boolean)this.validationStatus.isStale());
        MultiValidatorTest.assertEquals((int)0, (int)validationChangeCounter.count);
        MultiValidatorTest.assertEquals((int)0, (int)validationStaleCounter.count);
        this.dependency.setStale(true);
        MultiValidatorTest.assertTrue((boolean)this.validationStatus.isStale());
        MultiValidatorTest.assertEquals((int)0, (int)validationChangeCounter.count);
        MultiValidatorTest.assertEquals((int)1, (int)validationStaleCounter.count);
        this.dependency.fireStale();
        MultiValidatorTest.assertTrue((boolean)this.validationStatus.isStale());
        MultiValidatorTest.assertEquals((int)0, (int)validationChangeCounter.count);
        MultiValidatorTest.assertEquals((int)1, (int)validationStaleCounter.count);
        this.dependency.setValue(ValidationStatus.error((String)"e1"));
        MultiValidatorTest.assertTrue((boolean)this.validationStatus.isStale());
        MultiValidatorTest.assertEquals((int)1, (int)validationChangeCounter.count);
        MultiValidatorTest.assertEquals((int)1, (int)validationStaleCounter.count);
        this.dependency.setStale(false);
        MultiValidatorTest.assertFalse((boolean)this.dependency.isStale());
        MultiValidatorTest.assertFalse((boolean)this.validationStatus.isStale());
        MultiValidatorTest.assertEquals((int)2, (int)validationChangeCounter.count);
        MultiValidatorTest.assertEquals((int)1, (int)validationStaleCounter.count);
    }

    public void testStatusValueChangeWhileValidationStale() {
        this.dependency.setStale(true);
        MultiValidatorTest.assertTrue((boolean)this.validationStatus.isStale());
        this.dependency.setValue(ValidationStatus.error((String)"e1"));
        MultiValidatorTest.assertTrue((boolean)this.validationStatus.isStale());
        MultiValidatorTest.assertEquals((Object)this.dependency.getValue(), (Object)this.validationStatus.getValue());
        this.dependency.setValue(ValidationStatus.error((String)"e2"));
        MultiValidatorTest.assertTrue((boolean)this.validationStatus.isStale());
        MultiValidatorTest.assertEquals((Object)this.dependency.getValue(), (Object)this.validationStatus.getValue());
    }

    public void testValidationStatusBecomesStaleThroughNewDependency() {
        IStatus iStatus = ValidationStatus.ok();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final DependencyObservableValue nonStaleDependency = new DependencyObservableValue(iStatus, clazz);
        nonStaleDependency.setStale(false);
        IStatus iStatus2 = ValidationStatus.ok();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.runtime.IStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final DependencyObservableValue staleDependency = new DependencyObservableValue(iStatus2, clazz2);
        staleDependency.setStale(true);
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                if (nonStaleDependency.getValue() != null) {
                    return (IStatus)nonStaleDependency.getValue();
                }
                return (IStatus)staleDependency.getValue();
            }
        };
        this.validationStatus = this.validator.getValidationStatus();
        MultiValidatorTest.assertFalse((boolean)this.validationStatus.isStale());
        StaleEventTracker validationStaleCounter = StaleEventTracker.observe((IObservable)this.validationStatus);
        MultiValidatorTest.assertEquals((int)0, (int)validationStaleCounter.count);
        nonStaleDependency.setValue(null);
        MultiValidatorTest.assertTrue((boolean)this.validationStatus.isStale());
        MultiValidatorTest.assertEquals((int)1, (int)validationStaleCounter.count);
    }

    public void testBug251003_CompareDependenciesByIdentity() {
        DependencyObservable dependency1 = new DependencyObservable();
        DependencyObservable dependency2 = new DependencyObservable();
        MultiValidatorTest.assertEquals((Object)((Object)dependency1), (Object)((Object)dependency2));
        MultiValidatorTest.assertNotSame((Object)((Object)dependency1), (Object)((Object)dependency2));
        final ArrayList<DependencyObservable> dependencies = new ArrayList<DependencyObservable>();
        dependencies.add(dependency1);
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                Iterator it = dependencies.iterator();
                while (it.hasNext()) {
                    ObservableTracker.getterCalled((IObservable)((IObservable)it.next()));
                }
                return null;
            }
        };
        this.validationStatus = this.validator.getValidationStatus();
        IObservableList targets = this.validator.getTargets();
        MultiValidatorTest.assertEquals((int)1, (int)targets.size());
        MultiValidatorTest.assertSame((Object)((Object)dependency1), (Object)targets.get(0));
        dependencies.set(0, dependency2);
        dependency1.fireChange();
        MultiValidatorTest.assertEquals((int)1, (int)targets.size());
        MultiValidatorTest.assertSame((Object)((Object)dependency2), (Object)targets.get(0));
    }

    public void testBug251003_MissingDependencies() {
        final WritableList emptyListDependency = new WritableList();
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                ObservableTracker.getterCalled((IObservable)emptyListDependency);
                return null;
            }
        };
        this.validator.getValidationStatus().getValue();
        MultiValidatorTest.assertTrue((boolean)this.validator.getTargets().contains((Object)emptyListDependency));
    }

    public void testBug357568_MultiValidatorTargetAsDependency() {
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                ObservableTracker.getterCalled((IObservable)MultiValidatorTest.this.dependency);
                ObservableTracker.getterCalled((IObservable)new DependencyObservable());
                ObservableTracker.getterCalled((IObservable)MultiValidatorTest.this.validator.getTargets());
                return null;
            }
        };
        this.validator.getValidationStatus().getValue();
        this.dependency.setValue(ValidationStatus.info((String)"foo"));
    }

    public void testBug357568_ValidationStatusAsDependency() {
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                return (IStatus)MultiValidatorTest.this.validator.getValidationStatus().getValue();
            }
        };
        this.validator.getValidationStatus();
    }

    private static class DependencyObservable
    extends AbstractObservable {
        public DependencyObservable() {
            super(Realm.getDefault());
        }

        public boolean isStale() {
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == obj.getClass();
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }

        protected void fireChange() {
            super.fireChange();
        }
    }

    private static class DependencyObservableValue
    extends WritableValue {
        private boolean stale = false;

        public DependencyObservableValue(Object initialValue, Object valueType) {
            super(initialValue, valueType);
        }

        public boolean isStale() {
            ObservableTracker.getterCalled((IObservable)this);
            return this.stale;
        }

        public void setStale(boolean stale) {
            if (this.stale != stale) {
                this.stale = stale;
                if (stale) {
                    this.fireStale();
                } else {
                    this.fireValueChange(Diffs.createValueDiff((Object)this.doGetValue(), (Object)this.doGetValue()));
                }
            }
        }

        protected void fireStale() {
            super.fireStale();
        }
    }
}

