/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import junit.framework.TestCase;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BindingStatusTest
extends TestCase {
    private BindingStatus bindingStatus;

    protected void setUp() throws Exception {
        super.setUp();
        this.bindingStatus = BindingStatus.ok();
    }

    public void testMessageIsFromStatus() throws Exception {
        String message = "error message";
        IStatus status = ValidationStatus.error((String)message);
        this.bindingStatus.add(status);
        BindingStatusTest.assertEquals((String)message, (String)this.bindingStatus.getMessage());
    }

    public void testExceptionIsFromStatus() throws Exception {
        IllegalArgumentException e = new IllegalArgumentException();
        Status status = new Status(0, "org.eclipse.core.databinding", 0, "", (Throwable)e);
        this.bindingStatus.add((IStatus)status);
        BindingStatusTest.assertEquals((Object)e, (Object)this.bindingStatus.getException());
    }

    public void testPluginIsFromStatus() throws Exception {
        String plugin = "test";
        Status status = new Status(0, plugin, 0, "", null);
        this.bindingStatus.add((IStatus)status);
        BindingStatusTest.assertEquals((String)plugin, (String)this.bindingStatus.getPlugin());
    }

    public void testCodeIsFromStatus() throws Exception {
        int code = 1;
        Status status = new Status(0, "org.eclipse.core.databinding", code, "", null);
        this.bindingStatus.add((IStatus)status);
        BindingStatusTest.assertEquals((int)code, (int)status.getCode());
    }

    public void testSeverityIsFromStatus() throws Exception {
        IStatus status = ValidationStatus.error((String)"");
        this.bindingStatus.add(status);
        BindingStatusTest.assertEquals((int)4, (int)status.getSeverity());
    }

    public void testLowerSeverityDoesNotOverwriteGreaterSeverity() throws Exception {
        String info = "info";
        String error = "error";
        this.bindingStatus.add(ValidationStatus.error((String)error));
        BindingStatusTest.assertEquals((int)4, (int)this.bindingStatus.getSeverity());
        BindingStatusTest.assertEquals((String)error, (String)this.bindingStatus.getMessage());
        this.bindingStatus.add(ValidationStatus.info((String)info));
        BindingStatusTest.assertEquals((int)4, (int)this.bindingStatus.getSeverity());
        BindingStatusTest.assertEquals((String)error, (String)this.bindingStatus.getMessage());
        IStatus[] children = this.bindingStatus.getChildren();
        BindingStatusTest.assertEquals((int)2, (int)children.length);
        BindingStatusTest.assertEquals((int)4, (int)children[0].getSeverity());
        BindingStatusTest.assertEquals((int)1, (int)children[1].getSeverity());
    }

    public void testEqual() throws Exception {
        BindingStatus status1 = BindingStatus.ok();
        BindingStatus status2 = BindingStatus.ok();
        BindingStatusTest.assertEquals((Object)status1, (Object)status2);
    }

    public void testNotEqual() throws Exception {
        BindingStatus status1 = BindingStatus.ok();
        BindingStatus status2 = BindingStatus.ok();
        status2.add(ValidationStatus.error((String)""));
        BindingStatusTest.assertFalse((boolean)status1.equals((Object)status2));
    }

    public void testHashCode() throws Exception {
        BindingStatus status1 = BindingStatus.ok();
        BindingStatus status2 = BindingStatus.ok();
        BindingStatusTest.assertEquals((int)status1.hashCode(), (int)status2.hashCode());
    }

    public void testOkInitializesStatus() throws Exception {
        BindingStatus status = BindingStatus.ok();
        BindingStatusTest.assertEquals((String)"org.eclipse.core.databinding", (String)status.getPlugin());
        BindingStatusTest.assertEquals((String)"", (String)status.getMessage());
        BindingStatusTest.assertEquals((int)0, (int)status.getCode());
        BindingStatusTest.assertEquals((int)0, (int)status.getChildren().length);
        BindingStatusTest.assertNull((Object)status.getException());
    }
}

