/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;

public class IdentitySetTest
extends TestCase {
    IdentitySet set;

    protected void setUp() throws Exception {
        super.setUp();
        this.set = new IdentitySet();
    }

    public void testConstructor_NullComparer() {
        try {
            new ViewerElementSet(null);
            IdentitySetTest.fail((String)"Constructor should throw exception when null comparer passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testConstructorWithCollection_NullCollection() {
        try {
            new ViewerElementSet(null);
            IdentitySetTest.fail((String)"Constructor should throw exception when null collection passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testConstructorWithCollection_AddsAllElements() {
        Set<Object> toCopy = Collections.singleton(new Object());
        this.set = new IdentitySet(toCopy);
        IdentitySetTest.assertTrue((boolean)this.set.containsAll(toCopy));
    }

    public void testAdd_ContainsHonorsComparer() {
        String o1 = new String("string");
        String o2 = new String("string");
        IdentitySetTest.assertTrue((boolean)o1.equals(o2));
        IdentitySetTest.assertNotSame((Object)o1, (Object)o2);
        IdentitySetTest.assertTrue((boolean)this.set.add((Object)o1));
        IdentitySetTest.assertTrue((boolean)this.set.contains((Object)o1));
        IdentitySetTest.assertFalse((boolean)this.set.contains((Object)o2));
    }

    public void testAdd_FilterDuplicateElements() {
        Object o = new Object();
        IdentitySetTest.assertTrue((boolean)this.set.add(o));
        IdentitySetTest.assertFalse((boolean)this.set.add(o));
        IdentitySetTest.assertEquals((int)1, (int)this.set.size());
        IdentitySetTest.assertTrue((boolean)this.set.contains(o));
    }

    public void testAddAll_ContainsAllHonorsComparer() {
        String o1 = new String("o1");
        String o2 = new String("o2");
        List<Object> items = Arrays.asList(o1, o2);
        IdentitySetTest.assertTrue((boolean)this.set.addAll(items));
        IdentitySetTest.assertTrue((boolean)this.set.containsAll(items));
        IdentitySetTest.assertFalse((boolean)this.set.containsAll(Collections.singleton(new String("o1"))));
        IdentitySetTest.assertFalse((boolean)this.set.containsAll(Collections.singleton(new String("o2"))));
    }

    public void testAddAll_FiltersDuplicateElements() {
        Object o = new Object();
        this.set.add(o);
        IdentitySetTest.assertFalse((boolean)this.set.addAll(Collections.singleton(o)));
    }

    public void testClear() {
        this.set.add(new Object());
        IdentitySetTest.assertEquals((int)1, (int)this.set.size());
        this.set.clear();
        IdentitySetTest.assertEquals((int)0, (int)this.set.size());
    }

    public void testIsEmpty() {
        IdentitySetTest.assertTrue((boolean)this.set.isEmpty());
        this.set.add(new Object());
        IdentitySetTest.assertFalse((boolean)this.set.isEmpty());
    }

    public void testIterator() {
        Object o = new Object();
        this.set.add(o);
        Iterator iterator = this.set.iterator();
        IdentitySetTest.assertTrue((boolean)iterator.hasNext());
        IdentitySetTest.assertSame((Object)o, iterator.next());
        IdentitySetTest.assertTrue((boolean)this.set.contains(o));
        iterator.remove();
        IdentitySetTest.assertFalse((boolean)this.set.contains(o));
        IdentitySetTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testRemove() {
        Object o = new Object();
        IdentitySetTest.assertFalse((boolean)this.set.remove(o));
        IdentitySetTest.assertTrue((boolean)this.set.add(o));
        IdentitySetTest.assertTrue((boolean)this.set.contains(o));
        IdentitySetTest.assertTrue((boolean)this.set.remove(o));
        IdentitySetTest.assertFalse((boolean)this.set.contains(o));
    }

    public void testRemoveAll() {
        IdentitySetTest.assertFalse((boolean)this.set.removeAll((Collection)Collections.EMPTY_SET));
        Object o1 = new Object();
        Object o2 = new Object();
        this.set.addAll(Arrays.asList(o1, o2));
        IdentitySetTest.assertTrue((boolean)this.set.removeAll(Collections.singleton(o1)));
        IdentitySetTest.assertFalse((boolean)this.set.contains(o1));
        IdentitySetTest.assertFalse((boolean)this.set.removeAll(Collections.singleton(o1)));
        IdentitySetTest.assertTrue((boolean)this.set.removeAll(Arrays.asList(o2, "some", "other", "objects")));
        IdentitySetTest.assertFalse((boolean)this.set.contains(o2));
    }

    public void testRetainAll() {
        Object o1 = new Object();
        Object o2 = new Object();
        this.set.add(o1);
        this.set.add(o2);
        IdentitySetTest.assertFalse((boolean)this.set.retainAll(Arrays.asList(o1, o2)));
        IdentitySetTest.assertTrue((boolean)this.set.contains(o2));
        IdentitySetTest.assertTrue((boolean)this.set.retainAll(Collections.singleton(o1)));
        IdentitySetTest.assertFalse((boolean)this.set.contains(o2));
        IdentitySetTest.assertTrue((boolean)this.set.contains(o1));
        IdentitySetTest.assertTrue((boolean)this.set.retainAll((Collection)Collections.EMPTY_SET));
        IdentitySetTest.assertFalse((boolean)this.set.contains(o1));
    }

    public void testSize() {
        IdentitySetTest.assertEquals((int)0, (int)this.set.size());
        Object o = new Object();
        this.set.add(o);
        IdentitySetTest.assertEquals((int)1, (int)this.set.size());
        this.set.remove(o);
        IdentitySetTest.assertEquals((int)0, (int)this.set.size());
    }

    public void testToArray() {
        IdentitySetTest.assertEquals((int)0, (int)this.set.toArray().length);
        Object o = new Object();
        this.set.add(o);
        IdentitySetTest.assertTrue((boolean)Arrays.equals(new Object[]{o}, this.set.toArray()));
    }

    public void testToArrayWithObjectArray() {
        String o = new String("unique");
        this.set.add((Object)o);
        String[] array = (String[])this.set.toArray((Object[])new String[0]);
        IdentitySetTest.assertEquals((int)1, (int)array.length);
        IdentitySetTest.assertSame((Object)o, (Object)array[0]);
    }

    public void testEquals() {
        IdentitySetTest.assertTrue((boolean)this.set.equals((Object)this.set));
        IdentitySetTest.assertFalse((boolean)this.set.equals(null));
        IdentitySetTest.assertFalse((boolean)this.set.equals(new Object()));
        IdentitySetTest.assertTrue((boolean)this.set.equals((Object)Collections.EMPTY_SET));
        String o = new String("string");
        String distinct = new String("string");
        this.set.add((Object)o);
        IdentitySetTest.assertTrue((boolean)this.set.equals(Collections.singleton(o)));
        IdentitySetTest.assertFalse((boolean)this.set.equals(Collections.singleton(distinct)));
    }

    public void testHashCode() {
        IdentitySetTest.assertEquals((int)0, (int)this.set.hashCode());
        Object o = new Object();
        this.set.add(o);
        int hash = o.hashCode();
        IdentitySetTest.assertEquals((int)hash, (int)this.set.hashCode());
        Object o2 = new Object();
        this.set.add(o2);
        IdentitySetTest.assertEquals((int)(hash += o2.hashCode()), (int)this.set.hashCode());
    }
}

