/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.observable.Queue;

public class QueueTest
extends TestCase {
    private Queue queue;

    protected void setUp() throws Exception {
        this.queue = new Queue();
    }

    public void testIsEmpty() {
        QueueTest.assertTrue((boolean)this.queue.isEmpty());
        this.queue.enqueue((Object)"foo");
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        this.queue.enqueue((Object)"bar");
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        this.queue.dequeue();
        QueueTest.assertFalse((boolean)this.queue.isEmpty());
        this.queue.dequeue();
        QueueTest.assertTrue((boolean)this.queue.isEmpty());
    }

    public void testEnqueueAndDequeue() {
        try {
            this.queue.dequeue();
            QueueTest.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {}
        this.queue.enqueue((Object)"foo");
        QueueTest.assertEquals((Object)"foo", (Object)this.queue.dequeue());
        try {
            this.queue.dequeue();
            QueueTest.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {}
        this.queue.enqueue((Object)"foo");
        this.queue.enqueue((Object)"bar");
        this.queue.dequeue();
        this.queue.enqueue((Object)"bas");
        this.queue.enqueue((Object)"moo");
        QueueTest.assertEquals((Object)"bar", (Object)this.queue.dequeue());
        QueueTest.assertEquals((Object)"bas", (Object)this.queue.dequeue());
        QueueTest.assertEquals((Object)"moo", (Object)this.queue.dequeue());
        QueueTest.assertTrue((boolean)this.queue.isEmpty());
    }
}

