/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListenerSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.internal.databinding.beans.BeanPropertyListenerSupportTest;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class BeanPropertyListenerSupportTest
extends AbstractDefaultRealmTestCase {
    private PropertyChangeListenerStub listener;
    private String propertyName;

    protected void setUp() throws Exception {
        super.setUp();
        this.listener = new PropertyChangeListenerStub();
        this.propertyName = "value";
    }

    public void testAddPropertyChangeListenerWithPropertyName() throws Exception {
        SpecificListenerBean bean = new SpecificListenerBean();
        BeanPropertyListenerSupportTest.assertFalse((boolean)bean.changeSupport.hasListeners(this.propertyName));
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        BeanPropertyListenerSupportTest.assertTrue((String)"has listeners", (boolean)bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testAddPropertyChangeListenerWithoutPropertyName() throws Exception {
        GenericListenerBean bean = new GenericListenerBean();
        BeanPropertyListenerSupportTest.assertFalse((boolean)bean.changeSupport.hasListeners(this.propertyName));
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        BeanPropertyListenerSupportTest.assertTrue((String)"has listeners", (boolean)bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testLogStatusWhenAddPropertyChangeListenerMethodIsNotFound() throws Exception {
        class Log
        implements ILogger {
            int count;
            IStatus status;
            final /* synthetic */ BeanPropertyListenerSupportTest this$0;

            Log(BeanPropertyListenerSupportTest beanPropertyListenerSupportTest) {
                this.this$0 = beanPropertyListenerSupportTest;
            }

            public void log(IStatus status) {
                ++this.count;
                this.status = status;
            }
        }
        Log log = new Log(this);
        Policy.setLog((ILogger)log);
        class BeanStub {
            final /* synthetic */ BeanPropertyListenerSupportTest this$0;

            BeanStub(BeanPropertyListenerSupportTest beanPropertyListenerSupportTest) {
                this.this$0 = beanPropertyListenerSupportTest;
            }
        }
        BeanStub bean = new BeanStub(this);
        BeanPropertyListenerSupportTest.assertEquals((int)0, (int)log.count);
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)"value", (PropertyChangeListener)this.listener);
        BeanPropertyListenerSupportTest.assertEquals((int)1, (int)log.count);
        BeanPropertyListenerSupportTest.assertEquals((int)2, (int)log.status.getSeverity());
    }

    public void testRemovePropertyChangeListenerWithPropertyName() throws Exception {
        SpecificListenerBean bean = new SpecificListenerBean();
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        BeanPropertyListenerSupportTest.assertTrue((boolean)bean.changeSupport.hasListeners(this.propertyName));
        BeanPropertyListenerSupport.unhookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        BeanPropertyListenerSupportTest.assertFalse((String)"has listeners", (boolean)bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testRemovePropertyChangeListenerWithoutPropertyName() throws Exception {
        GenericListenerBean bean = new GenericListenerBean();
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        BeanPropertyListenerSupportTest.assertTrue((boolean)bean.changeSupport.hasListeners(this.propertyName));
        BeanPropertyListenerSupport.unhookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        BeanPropertyListenerSupportTest.assertFalse((String)"has listeners", (boolean)bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testLogStatusWhenRemovePropertyChangeListenerMethodIsNotFound() throws Exception {
        class Log
        implements ILogger {
            int count;
            IStatus status;
            final /* synthetic */ BeanPropertyListenerSupportTest this$0;

            Log(BeanPropertyListenerSupportTest beanPropertyListenerSupportTest) {
                this.this$0 = beanPropertyListenerSupportTest;
            }

            public void log(IStatus status) {
                ++this.count;
                this.status = status;
            }
        }
        Log log = new Log(this);
        Policy.setLog((ILogger)log);
        class InvalidBean {
            final /* synthetic */ BeanPropertyListenerSupportTest this$0;

            InvalidBean(BeanPropertyListenerSupportTest beanPropertyListenerSupportTest) {
                this.this$0 = beanPropertyListenerSupportTest;
            }
        }
        InvalidBean bean = new InvalidBean(this);
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)"value", (PropertyChangeListener)this.listener);
        log.count = 0;
        log.status = null;
        BeanPropertyListenerSupportTest.assertEquals((int)0, (int)log.count);
        BeanPropertyListenerSupport.unhookListener((Object)bean, (String)"value", (PropertyChangeListener)this.listener);
        BeanPropertyListenerSupportTest.assertEquals((int)1, (int)log.count);
        BeanPropertyListenerSupportTest.assertEquals((int)2, (int)log.status.getSeverity());
    }

    static class GenericListenerBean {
        private String other;
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        private String value;

        GenericListenerBean() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
            this.changeSupport.firePropertyChange("value", this.value, this.value);
        }

        public String getOther() {
            return this.other;
        }

        public void setOther(String other) {
            this.other = other;
            this.changeSupport.firePropertyChange("other", this.other, this.other);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    static class PropertyChangeListenerStub
    implements PropertyChangeListener {
        PropertyChangeEvent event;
        int count;

        PropertyChangeListenerStub() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
            this.event = evt;
        }
    }

    static class SpecificListenerBean {
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        String propertyName;
        String value;

        SpecificListenerBean() {
        }

        public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
            this.propertyName = name;
            this.changeSupport.addPropertyChangeListener(name, listener);
        }

        public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(name, listener);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

