/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListener;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class BeanPropertyListenerTest
extends AbstractDefaultRealmTestCase {
    private PropertyStub property;
    private PropertyDescriptor propertyDescriptor;
    private SimplePropertyListenerStub simpleListener;
    private BeanPropertyListenerStub listener;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        this.property = new PropertyStub();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.propertyDescriptor = new PropertyDescriptor("value", clazz);
        this.simpleListener = new SimplePropertyListenerStub();
        this.listener = new BeanPropertyListenerStub(this.property, this.propertyDescriptor, this.simpleListener);
    }

    public void testPropertyChange_ExpectedPropertyName() {
        Object source = new Object();
        String propertyName = "value";
        Object oldValue = new Object();
        Object newValue = new Object();
        this.listener.propertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        SimplePropertyEvent expectedEvent = new SimplePropertyEvent(SimplePropertyEvent.CHANGE, source, (IProperty)this.property, (IDiff)Diffs.createValueDiff((Object)oldValue, (Object)newValue));
        BeanPropertyListenerTest.assertEquals(Collections.singletonList(expectedEvent), (Object)this.simpleListener.log);
    }

    public void testPropertyChange_OtherPropertyName() {
        Object source = new Object();
        String propertyName = "other";
        Object oldValue = new Object();
        Object newValue = new Object();
        this.listener.propertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        BeanPropertyListenerTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.simpleListener.log);
    }

    public void testPropertyChange_NullPropertyName() {
        Object source = new Object();
        String propertyName = null;
        Object oldValue = null;
        Object newValue = null;
        this.listener.propertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        SimplePropertyEvent expectedEvent = new SimplePropertyEvent(SimplePropertyEvent.CHANGE, source, (IProperty)this.property, null);
        BeanPropertyListenerTest.assertEquals(Collections.singletonList(expectedEvent), (Object)this.simpleListener.log);
    }

    public void testPropertyChange_NullPropertyName_IgnoreOldAndNewValues() {
        Object source = new Object();
        String propertyName = null;
        Object oldValue = new Object();
        Object newValue = new Object();
        this.listener.propertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        SimplePropertyEvent expectedEvent = new SimplePropertyEvent(SimplePropertyEvent.CHANGE, source, (IProperty)this.property, null);
        BeanPropertyListenerTest.assertEquals(Collections.singletonList(expectedEvent), (Object)this.simpleListener.log);
    }

    private static class BeanPropertyListenerStub
    extends BeanPropertyListener {
        BeanPropertyListenerStub(IProperty property, PropertyDescriptor propertyDescriptor, ISimplePropertyListener listener) {
            super(property, propertyDescriptor, listener);
        }

        protected IDiff computeDiff(Object oldValue, Object newValue) {
            return Diffs.createValueDiff((Object)oldValue, (Object)newValue);
        }
    }

    private static class PropertyStub
    implements IProperty {
        private PropertyStub() {
        }
    }

    private static class SimplePropertyListenerStub
    implements ISimplePropertyListener {
        public List log = new ArrayList();

        private SimplePropertyListenerStub() {
        }

        public void handleEvent(SimplePropertyEvent event) {
            this.log.add(event);
        }
    }
}

