/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.MutableObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;

public class JavaBeanObservableArrayBasedListTest
extends AbstractDefaultRealmTestCase {
    private IObservableList list;
    private IBeanObservable beanObservable;
    private PropertyDescriptor propertyDescriptor;
    private Bean bean;
    private String propertyName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void setUp() throws Exception {
        super.setUp();
        this.propertyName = "array";
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.propertyDescriptor = BeanProperties.list((Class)clazz, (String)this.propertyName).getPropertyDescriptor();
        this.bean = new Bean(new Object[0]);
        this.list = BeansObservables.observeList((Realm)SWTObservables.getRealm((Display)Display.getDefault()), (Object)this.bean, (String)this.propertyName);
        this.beanObservable = (IBeanObservable)this.list;
    }

    public void testGetObserved() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.bean, (Object)this.beanObservable.getObserved());
    }

    public void testGetPropertyDescriptor() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)this.propertyDescriptor, (Object)this.beanObservable.getPropertyDescriptor());
    }

    public void testRegistersListenerAfterFirstListenerIsAdded() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.list.addListChangeListener((IListChangeListener)new ListChangeEventTracker());
        JavaBeanObservableArrayBasedListTest.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testRemovesListenerAfterLastListenerIsRemoved() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.list.removeListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testFiresListChangeEvents() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        this.bean.setArray(new Bean[]{new Bean()});
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
    }

    public void testAddAddsElement() throws Exception {
        int count = this.list.size();
        String element = "1";
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)count);
        this.list.add((Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)(count + 1), (int)this.list.size());
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)element, (Object)this.bean.getArray()[count]);
    }

    public void testAddListChangeEvent() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Collections.singletonList("1"));
    }

    public void testAdd_FiresPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.add((Object)"0");
            }
        });
    }

    public void testAddWithIndex() throws Exception {
        String element = "1";
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)this.list.size());
        this.list.add(0, (Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)element, (Object)this.bean.getArray()[0]);
    }

    public void testAddAtIndexListChangeEvent() throws Exception {
        String element = "1";
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.add(0, (Object)element);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Collections.singletonList("1"));
    }

    public void testAddAtIndexPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.add(0, (Object)"0");
            }
        });
    }

    public void testRemove() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)this.bean.getArray().length);
        this.list.remove((Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)this.bean.getArray().length);
    }

    public void testRemoveListChangeEvent() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.remove((Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.singletonList("1"), Collections.EMPTY_LIST);
    }

    public void testRemovePropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.remove((Object)"0");
            }
        });
    }

    public void testRemoveAtIndex() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)element, (Object)this.bean.getArray()[0]);
        this.list.remove(0);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)this.bean.getArray().length);
    }

    public void testRemoveAtIndexListChangeEvent() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.remove(0);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.singletonList(element), Collections.EMPTY_LIST);
    }

    public void testRemoveAtIndexPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.remove(0);
            }
        });
    }

    public void testAddAll() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)this.list.size());
        this.list.addAll(elements);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)2, (int)this.bean.getArray().length);
    }

    public void testAddAllListChangEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        this.list.addAll(elements);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Arrays.asList("1", "2"));
    }

    public void testAddAllPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.addAll(Arrays.asList("0", "1"));
            }
        });
    }

    public void testAddAllAtIndex() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)2, (int)this.list.size());
        this.list.addAll(2, elements);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)4, (int)this.bean.getArray().length);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)elements.get(0), (Object)this.bean.getArray()[0]);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)elements.get(1), (Object)this.bean.getArray()[1]);
    }

    public void testAddAllAtIndexListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        this.list.addAll(2, elements);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Arrays.asList("1", "2"), Arrays.asList("1", "2", "1", "2"));
    }

    public void testAddAllAtIndexPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.addAll(0, Arrays.asList("1", "2"));
            }
        });
    }

    public void testRemoveAll() throws Exception {
        this.list.addAll(Arrays.asList("1", "2", "3", "4"));
        JavaBeanObservableArrayBasedListTest.assertEquals((int)4, (int)this.bean.getArray().length);
        this.list.removeAll(Arrays.asList("2", "4"));
        JavaBeanObservableArrayBasedListTest.assertEquals((int)2, (int)this.bean.getArray().length);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)"1", (Object)this.bean.getArray()[0]);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)"3", (Object)this.bean.getArray()[1]);
    }

    public void testRemoveAllListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        this.list.removeAll(elements);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Arrays.asList("1", "2", "1", "2"), Collections.EMPTY_LIST);
    }

    public void testRemoveAllPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.removeAll(Arrays.asList("0"));
            }
        });
    }

    public void testRetainAll() throws Exception {
        List<String> elements = Arrays.asList("0", "1", "2", "3");
        this.list.addAll(elements);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)4, (int)this.bean.getArray().length);
        this.list.retainAll(elements.subList(0, 2));
        JavaBeanObservableArrayBasedListTest.assertEquals((int)2, (int)this.bean.getArray().length);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)elements.get(0), (Object)this.bean.getArray()[0]);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)elements.get(1), (Object)this.bean.getArray()[1]);
    }

    public void testRetainAllListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("0", "1", "2", "3");
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        this.list.retainAll(elements.subList(0, 2));
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Arrays.asList("0", "1", "2", "3"), Arrays.asList("0", "1"));
    }

    public void testRetainAllPropertyChangeEvent() throws Exception {
        this.list.addAll(Arrays.asList("0", "1"));
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.retainAll(Arrays.asList("0"));
            }
        });
    }

    public void testSet() throws Exception {
        String oldElement = "old";
        String newElement = "new";
        this.list.add((Object)oldElement);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)oldElement, (Object)this.bean.getArray()[0]);
        this.list.set(0, (Object)newElement);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)newElement, (Object)this.bean.getArray()[0]);
    }

    public void testMove() throws Exception {
        String element0 = "element0";
        String element1 = "element1";
        this.list.add((Object)element0);
        this.list.add((Object)element1);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)2, (int)this.bean.getArray().length);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)element0, (Object)this.bean.getArray()[0]);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)element1, (Object)this.bean.getArray()[1]);
        this.list.move(0, 1);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)2, (int)this.bean.getArray().length);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)element1, (Object)this.bean.getArray()[0]);
        JavaBeanObservableArrayBasedListTest.assertEquals((Object)element0, (Object)this.bean.getArray()[1]);
    }

    public void testSetListChangeEvent() throws Exception {
        String oldElement = "old";
        String newElement = "new";
        this.list.add((Object)oldElement);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        this.list.set(0, (Object)newElement);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.singletonList(oldElement), Collections.singletonList(newElement));
    }

    public void testSetPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableArrayBasedListTest.this.list.set(0, (Object)"1");
            }
        });
    }

    public void testListChangeEventFiresWhenNewListIsSet() throws Exception {
        Object[] elements = new Bean[]{new Bean(), new Bean()};
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        this.bean.setArray(elements);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)listener.count);
    }

    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setArray(new Object[]{"old"});
        IObservableList observable = BeansObservables.observeList((Realm)new CurrentRealm(true), (Object)bean, (String)"array");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        ((Bean)bean).setArray(new Object[]{"new"});
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)tracker.count);
        ArrayList<String> list = new ArrayList<String>();
        list.add("old");
        tracker.event.diff.applyTo(list);
        JavaBeanObservableArrayBasedListTest.assertEquals(Collections.singletonList("new"), list);
    }

    public void testModifyObservableList_FiresListChange() {
        Bean bean = new Bean(new Object[]{"old"});
        IObservableList observable = BeansObservables.observeList((Object)bean, (String)"array");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        observable.set(0, (Object)"new");
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableArrayBasedListTest.assertDiff(tracker.event.diff, Collections.singletonList("old"), Collections.singletonList("new"));
    }

    public void testSetBeanPropertyOutsideRealm_FiresEventInsideRealm() {
        Bean bean = new Bean(new Object[0]);
        CurrentRealm realm = new CurrentRealm(true);
        IObservableList observable = BeansObservables.observeList((Realm)realm, (Object)bean, (String)"array");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        realm.setCurrent(false);
        bean.setArray(new Object[]{"element"});
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)tracker.count);
        realm.setCurrent(true);
        JavaBeanObservableArrayBasedListTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableArrayBasedListTest.assertDiff(tracker.event.diff, Collections.EMPTY_LIST, Collections.singletonList("element"));
    }

    private static void assertDiff(ListDiff diff, List oldList, List newList) {
        oldList = new ArrayList(oldList);
        diff.applyTo(oldList);
        JavaBeanObservableArrayBasedListTest.assertEquals((String)"applying diff to list did not produce expected result", (Object)newList, oldList);
    }

    private static void assertPropertyChangeEvent(Bean bean, Runnable runnable) {
        PropertyChangeTracker listener = new PropertyChangeTracker();
        bean.addPropertyChangeListener(listener);
        Object[] old = bean.getArray();
        JavaBeanObservableArrayBasedListTest.assertEquals((int)0, (int)listener.count);
        runnable.run();
        PropertyChangeEvent event = listener.evt;
        JavaBeanObservableArrayBasedListTest.assertEquals((String)"event did not fire", (int)1, (int)listener.count);
        JavaBeanObservableArrayBasedListTest.assertEquals((String)"array", (String)event.getPropertyName());
        JavaBeanObservableArrayBasedListTest.assertTrue((String)"old value", (boolean)Arrays.equals(old, (Object[])event.getOldValue()));
        JavaBeanObservableArrayBasedListTest.assertTrue((String)"new value", (boolean)Arrays.equals(bean.getArray(), (Object[])event.getNewValue()));
        JavaBeanObservableArrayBasedListTest.assertFalse((String)"lists are equal", (boolean)Arrays.equals(bean.getArray(), old));
    }

    public static Test suite() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.JavaBeanObservableArrayBasedListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.JavaBeanObservableArrayBasedListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(MutableObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            String propertyName = "array";
            Bean bean = new Bean(new Object[0]);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IObservableList list = BeansObservables.observeList((Realm)realm, (Object)bean, (String)propertyName, (Class)clazz);
            int i = 0;
            while (i < elementCount) {
                list.add(this.createElement((IObservableCollection)list));
                ++i;
            }
            return list;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public void change(IObservable observable) {
            IObservableList list = (IObservableList)observable;
            list.add(this.createElement((IObservableCollection)list));
        }
    }

    private static class PropertyChangeTracker
    implements PropertyChangeListener {
        int count;
        PropertyChangeEvent evt;

        private PropertyChangeTracker() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
            this.evt = evt;
        }
    }
}

