/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.MutableObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;

public class JavaBeanObservableListTest
extends AbstractDefaultRealmTestCase {
    private IObservableList list;
    private IBeanObservable beanObservable;
    private PropertyDescriptor propertyDescriptor;
    private Bean bean;
    private String propertyName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void setUp() throws Exception {
        super.setUp();
        this.propertyName = "list";
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.propertyDescriptor = BeanProperties.list((Class)clazz, (String)this.propertyName).getPropertyDescriptor();
        this.bean = new Bean(new ArrayList());
        this.list = BeansObservables.observeList((Realm)SWTObservables.getRealm((Display)Display.getDefault()), (Object)this.bean, (String)this.propertyName);
        this.beanObservable = (IBeanObservable)this.list;
    }

    public void testGetObserved() throws Exception {
        JavaBeanObservableListTest.assertEquals((Object)this.bean, (Object)this.beanObservable.getObserved());
    }

    public void testGetPropertyDescriptor() throws Exception {
        JavaBeanObservableListTest.assertEquals((Object)this.propertyDescriptor, (Object)this.beanObservable.getPropertyDescriptor());
    }

    public void testRegistersListenerAfterFirstListenerIsAdded() throws Exception {
        JavaBeanObservableListTest.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.list.addListChangeListener((IListChangeListener)new ListChangeEventTracker());
        JavaBeanObservableListTest.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testRemovesListenerAfterLastListenerIsRemoved() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.list.removeListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    public void testFiresListChangeEvents() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        this.bean.setList(Arrays.asList("value"));
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
    }

    public void testAddAddsElement() throws Exception {
        int count = this.list.size();
        String element = "1";
        JavaBeanObservableListTest.assertEquals((int)0, (int)count);
        this.list.add((Object)element);
        JavaBeanObservableListTest.assertEquals((int)(count + 1), (int)this.list.size());
        JavaBeanObservableListTest.assertEquals((Object)element, this.bean.getList().get(count));
    }

    public void testAddListChangeEvent() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Collections.singletonList("1"));
    }

    public void testAddFiresPropertyChangeEvent() throws Exception {
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.add((Object)"0");
            }
        });
    }

    public void testAddAtIndex() throws Exception {
        String element = "1";
        JavaBeanObservableListTest.assertEquals((int)0, (int)this.list.size());
        this.list.add(0, (Object)element);
        JavaBeanObservableListTest.assertEquals((Object)element, this.bean.getList().get(0));
    }

    public void testAddAtIndexListChangeEvent() throws Exception {
        String element = "1";
        JavaBeanObservableListTest.assertEquals((int)0, (int)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.add(0, (Object)element);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Collections.singletonList("1"));
    }

    public void testAddAtIndexPropertyChangeEvent() throws Exception {
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.add(0, (Object)"0");
            }
        });
    }

    public void testClear() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableListTest.assertEquals((int)1, (int)this.bean.getList().size());
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.clear();
            }
        });
        JavaBeanObservableListTest.assertEquals((int)0, (int)this.bean.getList().size());
    }

    public void testRemove() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableListTest.assertEquals((int)1, (int)this.bean.getList().size());
        this.list.remove((Object)element);
        JavaBeanObservableListTest.assertEquals((int)0, (int)this.bean.getList().size());
    }

    public void testRemoveListChangeEvent() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableListTest.assertEquals((int)1, (int)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.remove((Object)element);
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertDiff(event.diff, Collections.singletonList("1"), Collections.EMPTY_LIST);
    }

    public void testRemovePropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.remove((Object)"0");
            }
        });
    }

    public void testRemoveAtIndex() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableListTest.assertEquals((Object)element, this.bean.getList().get(0));
        this.list.remove(0);
        JavaBeanObservableListTest.assertEquals((int)0, (int)this.bean.getList().size());
    }

    public void testRemoveAtIndexListChangeEvent() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        JavaBeanObservableListTest.assertEquals((int)1, (int)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.remove(0);
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertDiff(event.diff, Collections.singletonList(element), Collections.EMPTY_LIST);
    }

    public void testRemoveAtIndexPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.remove(0);
            }
        });
    }

    public void testAddAll() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        JavaBeanObservableListTest.assertEquals((int)0, (int)this.list.size());
        this.list.addAll(elements);
        JavaBeanObservableListTest.assertEquals((int)2, (int)this.bean.getList().size());
    }

    public void testAddAllListChangEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        JavaBeanObservableListTest.assertEquals((int)0, (int)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        this.list.addAll(elements);
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Arrays.asList("1", "2"));
    }

    public void testAddAllPropertyChangeEvent() throws Exception {
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.addAll(Arrays.asList("0", "1"));
            }
        });
    }

    public void testAddAllAtIndex() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        JavaBeanObservableListTest.assertEquals((int)2, (int)this.list.size());
        this.list.addAll(2, elements);
        JavaBeanObservableListTest.assertEquals((int)4, (int)this.bean.getList().size());
        JavaBeanObservableListTest.assertEquals((Object)elements.get(0), this.bean.getList().get(0));
        JavaBeanObservableListTest.assertEquals((Object)elements.get(1), this.bean.getList().get(1));
    }

    public void testAddAllAtIndexListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        this.list.addAll(2, elements);
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertDiff(event.diff, Arrays.asList("1", "2"), Arrays.asList("1", "2", "1", "2"));
    }

    public void testAddAllAtIndexPropertyChangeEvent() throws Exception {
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.addAll(0, Arrays.asList("1", "2"));
            }
        });
    }

    public void testRemoveAll() throws Exception {
        this.list.addAll(Arrays.asList("1", "2", "3", "4"));
        JavaBeanObservableListTest.assertEquals((int)4, (int)this.bean.getList().size());
        this.list.removeAll(Arrays.asList("2", "4"));
        JavaBeanObservableListTest.assertEquals((int)2, (int)this.bean.getList().size());
        JavaBeanObservableListTest.assertEquals((Object)"1", this.bean.getList().get(0));
        JavaBeanObservableListTest.assertEquals((Object)"3", this.bean.getList().get(1));
    }

    public void testRemoveAllListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        this.list.removeAll(elements);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertEquals((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertDiff(event.diff, Arrays.asList("1", "2", "1", "2"), Collections.EMPTY_LIST);
    }

    public void testRemoveAllPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.removeAll(Arrays.asList("0"));
            }
        });
    }

    public void testRetailAll() throws Exception {
        List<String> elements = Arrays.asList("0", "1", "2", "3");
        this.list.addAll(elements);
        JavaBeanObservableListTest.assertEquals((int)4, (int)this.bean.getList().size());
        this.list.retainAll(elements.subList(0, 2));
        JavaBeanObservableListTest.assertEquals((int)2, (int)this.bean.getList().size());
        JavaBeanObservableListTest.assertEquals((Object)elements.get(0), this.bean.getList().get(0));
        JavaBeanObservableListTest.assertEquals((Object)elements.get(1), this.bean.getList().get(1));
    }

    public void testRetainAllListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("0", "1", "2", "3");
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        this.list.retainAll(elements.subList(0, 2));
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertDiff(event.diff, Arrays.asList("0", "1", "2", "3"), Arrays.asList("0", "1"));
    }

    public void testRetainAllPropertyChangeEvent() throws Exception {
        this.list.addAll(Arrays.asList("0", "1"));
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.retainAll(Arrays.asList("0"));
            }
        });
    }

    public void testSet() throws Exception {
        String oldElement = "old";
        String newElement = "new";
        this.list.add((Object)oldElement);
        JavaBeanObservableListTest.assertEquals((Object)oldElement, this.bean.getList().get(0));
        this.list.set(0, (Object)newElement);
        JavaBeanObservableListTest.assertEquals((Object)newElement, this.bean.getList().get(0));
    }

    public void testMove() throws Exception {
        String element0 = "element0";
        String element1 = "element1";
        this.list.add((Object)element0);
        this.list.add((Object)element1);
        JavaBeanObservableListTest.assertEquals((int)2, (int)this.bean.getList().size());
        JavaBeanObservableListTest.assertEquals((Object)element0, this.bean.getList().get(0));
        JavaBeanObservableListTest.assertEquals((Object)element1, this.bean.getList().get(1));
        this.list.move(0, 1);
        JavaBeanObservableListTest.assertEquals((int)2, (int)this.bean.getList().size());
        JavaBeanObservableListTest.assertEquals((Object)element1, this.bean.getList().get(0));
        JavaBeanObservableListTest.assertEquals((Object)element0, this.bean.getList().get(1));
    }

    public void testSetListChangeEvent() throws Exception {
        String oldElement = "old";
        String newElement = "new";
        this.list.add((Object)oldElement);
        ListChangeEventTracker listener = ListChangeEventTracker.observe((IObservableList)this.list);
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        this.list.set(0, (Object)newElement);
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
        ListChangeEvent event = listener.event;
        JavaBeanObservableListTest.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableListTest.assertDiff(event.diff, Collections.singletonList(oldElement), Collections.singletonList(newElement));
    }

    public void testSetPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableListTest.assertPropertyChangeEvent(this.bean, new Runnable(){

            public void run() {
                JavaBeanObservableListTest.this.list.set(0, (Object)"1");
            }
        });
    }

    public void testListChangeEventFiresWhenNewListIsSet() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        this.bean.setList(elements);
        JavaBeanObservableListTest.assertEquals((int)1, (int)listener.count);
    }

    public void testConstructor_RegistersListener() throws Exception {
        Bean bean = new Bean();
        IObservableList observable = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)bean, (String)"list");
        JavaBeanObservableListTest.assertFalse((boolean)bean.hasListeners("list"));
        ChangeEventTracker.observe((IObservable)observable);
        JavaBeanObservableListTest.assertTrue((boolean)bean.hasListeners("list"));
    }

    public void testConstructor_SkipsRegisterListener() throws Exception {
        Bean bean = new Bean();
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)bean, (String)"list");
        JavaBeanObservableListTest.assertFalse((boolean)bean.hasListeners("list"));
        ChangeEventTracker.observe((IObservable)observable);
        JavaBeanObservableListTest.assertFalse((boolean)bean.hasListeners("list"));
    }

    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setList(Collections.singletonList("old"));
        IObservableList observable = BeansObservables.observeList((Realm)new CurrentRealm(true), (Object)bean, (String)"list");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        ((Bean)bean).setList(Collections.singletonList("new"));
        JavaBeanObservableListTest.assertEquals((int)1, (int)tracker.count);
        ArrayList<String> list = new ArrayList<String>();
        list.add("old");
        tracker.event.diff.applyTo(list);
        JavaBeanObservableListTest.assertEquals(Collections.singletonList("new"), list);
    }

    public void testModifyObservableList_FiresListChange() {
        Bean bean = new Bean(new ArrayList());
        IObservableList observable = BeansObservables.observeList((Object)bean, (String)"list");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        Object element = new Object();
        observable.add(element);
        JavaBeanObservableListTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableListTest.assertDiff(tracker.event.diff, Collections.EMPTY_LIST, Collections.singletonList(element));
    }

    public void testSetBeanPropertyOutsideRealm_FiresEventInsideRealm() {
        Bean bean = new Bean(Collections.EMPTY_LIST);
        CurrentRealm realm = new CurrentRealm(true);
        IObservableList observable = BeansObservables.observeList((Realm)realm, (Object)bean, (String)"list");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        realm.setCurrent(false);
        bean.setList(Collections.singletonList("element"));
        JavaBeanObservableListTest.assertEquals((int)0, (int)tracker.count);
        realm.setCurrent(true);
        JavaBeanObservableListTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableListTest.assertDiff(tracker.event.diff, Collections.EMPTY_LIST, Collections.singletonList("element"));
    }

    public void testUpdatedBeanListIsModifiable() {
        Bean bean = new Bean(new ArrayList());
        IObservableList observable = BeansObservables.observeList((Object)bean, (String)"list");
        observable.add(new Object());
        bean.getList().clear();
    }

    public void testUpdatedPojoListIsModifiable() {
        Bean bean = new Bean(new ArrayList());
        IObservableList observable = PojoObservables.observeList((Object)bean, (String)"list");
        observable.add(new Object());
        bean.getList().clear();
    }

    private static void assertDiff(ListDiff diff, List oldList, List newList) {
        oldList = new ArrayList(oldList);
        diff.applyTo(oldList);
        JavaBeanObservableListTest.assertEquals((String)"applying diff to list did not produce expected result", (Object)newList, oldList);
    }

    private static void assertPropertyChangeEvent(Bean bean, Runnable runnable) {
        PropertyChangeTracker listener = new PropertyChangeTracker();
        bean.addPropertyChangeListener(listener);
        List old = bean.getList();
        JavaBeanObservableListTest.assertEquals((int)0, (int)listener.count);
        runnable.run();
        PropertyChangeEvent event = listener.evt;
        JavaBeanObservableListTest.assertEquals((String)"event did not fire", (int)1, (int)listener.count);
        JavaBeanObservableListTest.assertEquals((String)"list", (String)event.getPropertyName());
        JavaBeanObservableListTest.assertEquals((String)"old value", (Object)old, (Object)event.getOldValue());
        JavaBeanObservableListTest.assertEquals((String)"new value", (Object)bean.getList(), (Object)event.getNewValue());
        JavaBeanObservableListTest.assertFalse((String)"lists are equal", (boolean)bean.getList().equals(old));
    }

    public static Test suite() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.JavaBeanObservableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.JavaBeanObservableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(MutableObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            String propertyName = "list";
            Bean bean = new Bean(new ArrayList());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IObservableList list = BeansObservables.observeList((Realm)realm, (Object)bean, (String)propertyName, (Class)clazz);
            int i = 0;
            while (i < elementCount) {
                list.add(this.createElement((IObservableCollection)list));
                ++i;
            }
            return list;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object().toString();
        }

        public Object getElementType(IObservableCollection collection) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public void change(IObservable observable) {
            IObservableList list = (IObservableList)observable;
            list.add(this.createElement((IObservableCollection)list));
        }
    }

    private static class PropertyChangeTracker
    implements PropertyChangeListener {
        int count;
        PropertyChangeEvent evt;

        private PropertyChangeTracker() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
            this.evt = evt;
        }
    }
}

