/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class JavaBeanObservableValueTest
extends AbstractDefaultRealmTestCase {
    private Bean bean;
    private IObservableValue observableValue;
    private IBeanObservable beanObservable;
    private PropertyDescriptor propertyDescriptor;
    private String propertyName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new Bean();
        this.propertyName = "value";
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.propertyDescriptor = BeanProperties.value((Class)clazz, (String)this.propertyName).getPropertyDescriptor();
        this.observableValue = BeansObservables.observeValue((Object)this.bean, (String)this.propertyName);
        this.beanObservable = (IBeanObservable)this.observableValue;
    }

    public void testGetObserved() throws Exception {
        JavaBeanObservableValueTest.assertEquals((Object)this.bean, (Object)this.beanObservable.getObserved());
    }

    public void testGetPropertyDescriptor() throws Exception {
        JavaBeanObservableValueTest.assertEquals((Object)this.propertyDescriptor, (Object)this.beanObservable.getPropertyDescriptor());
    }

    public void testSetValueThrowsExceptionThrownByBean() throws Exception {
        ThrowsSetException temp = new ThrowsSetException();
        IObservableValue observable = BeansObservables.observeValue((Object)temp, (String)"value");
        try {
            observable.setValue((Object)"");
            JavaBeanObservableValueTest.fail((String)"exception should have been thrown");
        }
        catch (RuntimeException e) {
            JavaBeanObservableValueTest.assertEquals((Object)temp.thrownException, (Object)e.getCause());
        }
    }

    public void testGetValueThrowsExceptionThrownByBean() throws Exception {
        ThrowsGetException temp = new ThrowsGetException();
        IObservableValue observable = BeansObservables.observeValue((Object)temp, (String)"value");
        try {
            observable.getValue();
            JavaBeanObservableValueTest.fail((String)"exception should have been thrown");
        }
        catch (RuntimeException e) {
            JavaBeanObservableValueTest.assertEquals((Object)temp.thrownException, (Object)e.getCause());
        }
    }

    public void testBug198519() {
        SimplePerson person = new SimplePerson();
        final ComputedValue cv = new ComputedValue(person){
            final IObservableValue name;
            {
                this.name = BeansObservables.observeValue((Object)simplePerson, (String)"name");
            }

            protected Object calculate() {
                return this.name.getValue() != null;
            }
        };
        cv.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                cv.getValue();
            }
        });
        person.setName("foo");
    }

    public void testConstructor_RegistersListeners() throws Exception {
        IObservableValue observable = BeansObservables.observeValue((Object)this.bean, (String)this.propertyName);
        ChangeEventTracker.observe((IObservable)observable);
        JavaBeanObservableValueTest.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
    }

    public void testConstructor_SkipRegisterListeners() throws Exception {
        IObservableValue observable = PojoObservables.observeValue((Object)this.bean, (String)this.propertyName);
        ChangeEventTracker.observe((IObservable)observable);
        JavaBeanObservableValueTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setValue("old");
        IObservableValue observable = BeansObservables.observeValue((Object)bean, (String)"value");
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)observable);
        ((Bean)bean).setValue("new");
        JavaBeanObservableValueTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableValueTest.assertEquals((Object)"old", (Object)tracker.event.diff.getOldValue());
        JavaBeanObservableValueTest.assertEquals((Object)"new", (Object)tracker.event.diff.getNewValue());
    }

    public void testSetBeanPropertyOutsideRealm_FiresEventInsideRealm() {
        Bean bean = new Bean("old");
        CurrentRealm realm = new CurrentRealm(true);
        IObservableValue observable = BeansObservables.observeValue((Realm)realm, (Object)bean, (String)"value");
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)observable);
        realm.setCurrent(false);
        bean.setValue("new");
        JavaBeanObservableValueTest.assertEquals((int)0, (int)tracker.count);
        realm.setCurrent(true);
        JavaBeanObservableValueTest.assertEquals((int)1, (int)tracker.count);
        JavaBeanObservableValueTest.assertEquals((Object)Diffs.createValueDiff((Object)"old", (Object)"new"), (Object)tracker.event.diff);
    }

    public static Test suite() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.JavaBeanObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.JavaBeanObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Bean bean;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.bean = new Bean("");
        }

        public IObservableValue createObservableValue(Realm realm) {
            return BeansObservables.observeValue((Realm)realm, (Object)this.bean, (String)"value");
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object getValueType(IObservableValue observable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public Object createValue(IObservableValue observable) {
            return observable.getValue() + "a";
        }
    }

    class ThrowsGetException {
        public String value;
        NullPointerException thrownException;

        ThrowsGetException() {
        }

        public String getValue() {
            this.thrownException = new NullPointerException();
            throw this.thrownException;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class ThrowsSetException {
        private String value;
        NullPointerException thrownException;

        ThrowsSetException() {
        }

        public void setValue(String value) {
            this.thrownException = new NullPointerException();
            throw this.thrownException;
        }

        public String getValue() {
            return this.value;
        }
    }
}

