/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.internal.databinding.conversion.DateConversionSupport;

public class DateConversionSupportTest
extends TestCase {
    public void testDatePatternIsExternalized() throws Exception {
        StubConverter stub = new StubConverter();
        String key = "DateFormat_DateTime";
        String format = BindingMessages.getString((String)key);
        DateConversionSupportTest.assertFalse((String)"format is defined", (boolean)key.equals(format));
        SimpleDateFormat dateFormat = (SimpleDateFormat)stub.getDateFormat(0);
        DateConversionSupportTest.assertEquals((String)format, (String)dateFormat.toPattern());
    }

    public void testTimePatternIsExternalized() throws Exception {
        StubConverter stub = new StubConverter();
        String key = "DateFormat_Time";
        String format = BindingMessages.getString((String)key);
        DateConversionSupportTest.assertFalse((String)"format is defined", (boolean)key.equals(format));
        SimpleDateFormat dateFormat = (SimpleDateFormat)stub.getDateFormat(1);
        DateConversionSupportTest.assertEquals((String)format, (String)dateFormat.toPattern());
    }

    public void testFormat_NullDate() {
        StubConverter stub = new StubConverter();
        DateConversionSupportTest.assertNull((Object)stub.format(null));
    }

    static class StubConverter
    extends DateConversionSupport {
        StubConverter() {
        }

        protected DateFormat getDateFormat(int index) {
            return super.getDateFormat(index);
        }

        protected String format(Date date) {
            return super.format(date);
        }
    }
}

