/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import junit.framework.TestCase;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;

public class IdentityConverterTest
extends TestCase {
    private IdentityConverter c;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    protected void setUp() throws Exception {
        this.c = new IdentityConverter(Integer.TYPE, Integer.TYPE);
    }

    public void testIsPrimitiveTypeMatchedWithBoxed() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz, Integer.TYPE));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Integer.TYPE, (Class)clazz2));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz3, Byte.TYPE));
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Byte.TYPE, (Class)clazz4));
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz5, Short.TYPE));
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Short.TYPE, (Class)clazz6));
        Class<?> clazz7 = class$3;
        if (clazz7 == null) {
            try {
                clazz7 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz7, Long.TYPE));
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Long.TYPE, (Class)clazz8));
        Class<?> clazz9 = class$4;
        if (clazz9 == null) {
            try {
                clazz9 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz9, Float.TYPE));
        Class<?> clazz10 = class$4;
        if (clazz10 == null) {
            try {
                clazz10 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Float.TYPE, (Class)clazz10));
        Class<?> clazz11 = class$5;
        if (clazz11 == null) {
            try {
                clazz11 = class$5 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz11, Double.TYPE));
        Class<?> clazz12 = class$5;
        if (clazz12 == null) {
            try {
                clazz12 = class$5 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Double.TYPE, (Class)clazz12));
        Class<?> clazz13 = class$6;
        if (clazz13 == null) {
            try {
                clazz13 = class$6 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz13, Boolean.TYPE));
        Class<?> clazz14 = class$6;
        if (clazz14 == null) {
            try {
                clazz14 = class$6 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Boolean.TYPE, (Class)clazz14));
        Class<?> clazz15 = class$7;
        if (clazz15 == null) {
            try {
                clazz15 = class$7 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz15, Character.TYPE));
        Class<?> clazz16 = class$7;
        if (clazz16 == null) {
            try {
                clazz16 = class$7 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Character.TYPE, (Class)clazz16));
        Class<?> clazz17 = class$6;
        if (clazz17 == null) {
            try {
                clazz17 = class$6 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertFalse((boolean)this.c.isPrimitiveTypeMatchedWithBoxed((Class)clazz17, Integer.TYPE));
    }

    public void testConvert_NullToPrimitive() {
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, Float.TYPE);
        try {
            p2b.convert(null);
            IdentityConverterTest.fail((String)"Should have thrown an exception");
        }
        catch (BindingException bindingException) {}
    }

    public void testConvert_PrimitiveToBoxed() throws Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, (Class)clazz);
        IdentityConverterTest.assertEquals((String)"4.2", (Object)new Float(4.2), (Object)p2b.convert((Object)new Float(4.2)));
    }

    public void testConvert_BoxedToPrimitive() throws Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverter p2b = new IdentityConverter((Class)clazz, Float.TYPE);
        IdentityConverterTest.assertEquals((String)"4.2", (Object)new Float(4.2), (Object)p2b.convert((Object)new Float(4.2)));
    }

    public void testConvert_PrimitiveToPrimitive() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, Float.TYPE);
        IdentityConverterTest.assertEquals((String)"4.2", (Object)new Float(4.2), (Object)p2b.convert((Object)new Float(4.2)));
    }

    public void testConvert_BoxedToBoxed() throws Exception {
        Class<?> clazz;
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$4) == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverter p2b = new IdentityConverter((Class)clazz2, (Class)clazz);
        IdentityConverterTest.assertEquals((String)"4.2", (Object)new Float(4.2), (Object)p2b.convert((Object)new Float(4.2)));
    }

    public void test_Convert_ValidAssignment() throws Exception {
        Class<?> clazz;
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$9) == null) {
            try {
                clazz = class$9 = Class.forName("org.eclipse.core.tests.internal.databinding.conversion.IdentityConverterTest$Person");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverter pc = new IdentityConverter((Class)clazz2, (Class)clazz);
        Person orig = new Person();
        Object person = pc.convert((Object)orig);
        Class<?> clazz3 = person.getClass();
        Class<?> clazz4 = class$9;
        if (clazz4 == null) {
            try {
                clazz4 = class$9 = Class.forName("org.eclipse.core.tests.internal.databinding.conversion.IdentityConverterTest$Person");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((String)"Person class", (boolean)clazz3.equals(clazz4));
        IdentityConverterTest.assertTrue((String)"Need correct Person", (boolean)person.equals(orig));
    }

    public void test_Convert_ValidAssignment2() throws Exception {
        Class<?> clazz;
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("org.eclipse.core.tests.internal.databinding.conversion.IdentityConverterTest$Person");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$8) == null) {
            try {
                clazz = class$8 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverter pc = new IdentityConverter((Class)clazz2, (Class)clazz);
        Person orig = new Person();
        Object person = pc.convert((Object)orig);
        Class<?> clazz3 = person.getClass();
        Class<?> clazz4 = class$9;
        if (clazz4 == null) {
            try {
                clazz4 = class$9 = Class.forName("org.eclipse.core.tests.internal.databinding.conversion.IdentityConverterTest$Person");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverterTest.assertTrue((String)"Person class", (boolean)clazz3.equals(clazz4));
        IdentityConverterTest.assertTrue((String)"Need correct Person", (boolean)person.equals(orig));
    }

    public void testConvert_InvalidAssignment() throws Exception {
        Class<?> clazz;
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$9) == null) {
            try {
                clazz = class$9 = Class.forName("org.eclipse.core.tests.internal.databinding.conversion.IdentityConverterTest$Person");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IdentityConverter pc = new IdentityConverter((Class)clazz2, (Class)clazz);
        try {
            pc.convert((Object)new Animal());
            IdentityConverterTest.fail((String)"Should have gotten an exception");
        }
        catch (Exception exception) {}
    }

    public static class Animal {
        public String name = "fido";
    }

    public static class Person {
        public String foo = "blah";
    }
}

