/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import junit.framework.TestCase;
import org.eclipse.core.databinding.conversion.IConverter;

public abstract class NumberToNumberTestHarness
extends TestCase {
    static /* synthetic */ Class class$0;

    protected abstract IConverter doGetToPrimitiveValidator(Class var1);

    protected abstract IConverter doGetToBoxedTypeValidator(Class var1);

    protected abstract Class doGetToType(boolean var1);

    protected abstract Number doGetOutOfRangeNumber();

    public void testFromType() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> from = clazz;
        NumberToNumberTestHarness.assertEquals(from, (Object)this.doGetToBoxedTypeValidator(from).getFromType());
    }

    public void testToTypeIsPrimitive() throws Exception {
        Class toType = this.doGetToType(true);
        if (toType == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToNumberTestHarness.assertEquals((String)"to type was not of the correct type", (Object)toType, (Object)this.doGetToPrimitiveValidator(clazz).getToType());
        NumberToNumberTestHarness.assertTrue((String)"to type was not primitive", (boolean)toType.isPrimitive());
    }

    public void testToTypeIsBoxedType() throws Exception {
        Class toType = this.doGetToType(false);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToNumberTestHarness.assertEquals((Object)toType, (Object)this.doGetToBoxedTypeValidator(clazz).getToType());
        NumberToNumberTestHarness.assertFalse((boolean)toType.isPrimitive());
    }

    public void testValidConversion() throws Exception {
        Integer value = new Integer(1);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Number result = (Number)this.doGetToBoxedTypeValidator(clazz).convert((Object)value);
        NumberToNumberTestHarness.assertNotNull((String)"result was null", (Object)result);
        NumberToNumberTestHarness.assertEquals((Object)this.doGetToType(false), result.getClass());
        NumberToNumberTestHarness.assertEquals((Object)value, (Object)new Integer(result.intValue()));
    }

    public void testOutOfRangeConversion() throws Exception {
        Number outOfRange = this.doGetOutOfRangeNumber();
        if (outOfRange == null) {
            return;
        }
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.doGetToBoxedTypeValidator(clazz).convert((Object)outOfRange);
            NumberToNumberTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testConvertNullValueForPrimitiveThrowsIllegalArgumentException() throws Exception {
        if (this.doGetToType(true) == null) {
            return;
        }
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.doGetToPrimitiveValidator(clazz).convert(null);
            NumberToNumberTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testConvertNullValueForBoxedTypeReturnsNull() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToNumberTestHarness.assertNull((Object)this.doGetToBoxedTypeValidator(clazz).convert(null));
    }

    public void testNonNumberThrowsIllegalArgumentException() throws Exception {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.doGetToBoxedTypeValidator(clazz).convert((Object)"");
            NumberToNumberTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

