/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.internal.databinding.conversion.StringToBooleanConverter;

public class StringToBooleanConverterTest
extends TestCase {
    private StringToBooleanConverter converter;
    private List trueValues;
    private List falseValues;

    public void run(TestResult result) {
        this.trueValues = Collections.unmodifiableList(this.toValues(BindingMessages.getString((String)"ValueDelimiter"), BindingMessages.getString((String)"TrueStringValues")));
        this.falseValues = Collections.unmodifiableList(this.toValues(BindingMessages.getString((String)"ValueDelimiter"), BindingMessages.getString((String)"FalseStringValues")));
        super.run(result);
    }

    private List toValues(String delimiter, String values) {
        StringTokenizer tokenizer = new StringTokenizer(values, delimiter);
        LinkedList<String> result = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.converter = new StringToBooleanConverter();
        StringToBooleanConverterTest.assertTrue((this.trueValues.size() > 0 ? 1 : 0) != 0);
        StringToBooleanConverterTest.assertTrue((this.falseValues.size() > 0 ? 1 : 0) != 0);
    }

    public void testConvertsToTrue() throws Exception {
        Boolean result = (Boolean)this.converter.convert(this.trueValues.get(0));
        StringToBooleanConverterTest.assertTrue((boolean)result);
    }

    public void testConvertsToFalse() throws Exception {
        Boolean result = (Boolean)this.converter.convert(this.falseValues.get(0));
        StringToBooleanConverterTest.assertFalse((boolean)result);
    }

    public void testUpperCaseStringConvertsToTrue() throws Exception {
        Boolean result = (Boolean)this.converter.convert((Object)((String)this.trueValues.get(0)).toUpperCase());
        StringToBooleanConverterTest.assertTrue((boolean)result);
    }

    public void testUpperCaseStringConvertsToFalse() throws Exception {
        Boolean result = (Boolean)this.converter.convert((Object)((String)this.falseValues.get(0)).toUpperCase());
        StringToBooleanConverterTest.assertFalse((boolean)result);
    }
}

