/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.StringToByteConverter;

public class StringToByteConverterTest
extends TestCase {
    private NumberFormat numberFormat;
    private StringToByteConverter converter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.converter = StringToByteConverter.toByte((NumberFormat)this.numberFormat, (boolean)false);
    }

    public void testConvertsToByte() throws Exception {
        Byte value = new Byte(1);
        Byte result = (Byte)this.converter.convert((Object)this.numberFormat.format((Object)value));
        StringToByteConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testConvertsToBytePrimitive() throws Exception {
        this.converter = StringToByteConverter.toByte((NumberFormat)this.numberFormat, (boolean)true);
        Byte value = new Byte(1);
        Byte result = (Byte)this.converter.convert((Object)this.numberFormat.format((Object)value));
        StringToByteConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testFromTypeIsString() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToByteConverterTest.assertEquals((Object)clazz, (Object)this.converter.getFromType());
    }

    public void testToTypeIsShort() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToByteConverterTest.assertEquals((Object)clazz, (Object)this.converter.getToType());
    }

    public void testToTypeIsBytePrimitive() throws Exception {
        this.converter = StringToByteConverter.toByte((boolean)true);
        StringToByteConverterTest.assertEquals(Byte.TYPE, (Object)this.converter.getToType());
    }

    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        StringToByteConverterTest.assertNull((Object)this.converter.convert((Object)""));
    }

    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        try {
            this.converter.convert((Object)new Integer(1));
            StringToByteConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

