/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.eclipse.core.tests.internal.databinding.conversion.StringToNumberParserTestHarness;

public abstract class StringToNumberParserTestHarness
extends TestCase {
    protected abstract Number getValidMax();

    protected abstract Number getValidMin();

    protected abstract boolean assertValid(Number var1);

    public void testRanges() throws Exception {
        Number min = this.getValidMin();
        Number max = this.getValidMax();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        StringToNumberParserTestHarness.assertTrue((String)"valid byte", (boolean)this.assertValid(new Byte(1)));
        StringToNumberParserTestHarness.assertTrue((String)"valid byte min", (boolean)this.assertValid(new Byte(-128)));
        StringToNumberParserTestHarness.assertTrue((String)"valid byte max", (boolean)this.assertValid(new Byte(127)));
        StringToNumberParserTestHarness.assertTrue((String)"valid short", (boolean)this.assertValid(new Short(1)));
        boolean result = this.assertValid(new Short(Short.MIN_VALUE));
        if (minDouble > -32768.0) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid short min", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid short min", (boolean)result);
        }
        result = this.assertValid(new Short(Short.MAX_VALUE));
        if (maxDouble < 32767.0) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid short max", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid short max", (boolean)result);
        }
        StringToNumberParserTestHarness.assertTrue((String)"valid Integer", (boolean)this.assertValid(new Integer(1)));
        result = this.assertValid(new Integer(Integer.MIN_VALUE));
        if (minDouble > -2.147483648E9) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid Integer min", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid integer min", (boolean)result);
        }
        result = this.assertValid(new Integer(Integer.MAX_VALUE));
        if (maxDouble < 2.147483647E9) {
            StringToNumberParserTestHarness.assertFalse((String)"valid Integer max", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid integer max", (boolean)result);
        }
        StringToNumberParserTestHarness.assertTrue((String)"valid long", (boolean)this.assertValid(new Long(1L)));
        result = this.assertValid(new Long(Long.MIN_VALUE));
        if (minDouble > -9.223372036854776E18) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid long min", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid long min", (boolean)result);
        }
        result = this.assertValid(new Long(Long.MAX_VALUE));
        if (maxDouble < 9.223372036854776E18) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid long max", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid long max", (boolean)result);
        }
        StringToNumberParserTestHarness.assertTrue((String)"valid float", (boolean)this.assertValid(new Float(1.0f)));
        result = this.assertValid(new Float(-3.4028235E38f));
        if (minDouble > -3.4028234663852886E38) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid float min", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid float min", (boolean)result);
        }
        result = this.assertValid(new Float(Float.MAX_VALUE));
        if (maxDouble < 3.4028234663852886E38) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid float max", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid float max", (boolean)result);
        }
        StringToNumberParserTestHarness.assertFalse((String)"invalid negative float infinity", (boolean)this.assertValid(new Float(Float.NEGATIVE_INFINITY)));
        StringToNumberParserTestHarness.assertFalse((String)"invalid positive float infinity", (boolean)this.assertValid(new Float(Float.POSITIVE_INFINITY)));
        StringToNumberParserTestHarness.assertFalse((String)"invalid float NaN", (boolean)this.assertValid(new Float(Float.NaN)));
        StringToNumberParserTestHarness.assertTrue((String)"valid double", (boolean)this.assertValid(new Double(1.0)));
        result = this.assertValid(new Double(-1.7976931348623157E308));
        if (minDouble > -1.7976931348623157E308) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid double min", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid double min", (boolean)result);
        }
        result = this.assertValid(new Double(Double.MAX_VALUE));
        if (maxDouble < Double.MAX_VALUE) {
            StringToNumberParserTestHarness.assertFalse((String)"invalid float max", (boolean)result);
        } else {
            StringToNumberParserTestHarness.assertTrue((String)"valid float max", (boolean)result);
        }
        StringToNumberParserTestHarness.assertFalse((String)"invalid negative double infinity", (boolean)this.assertValid(new Double(Double.NEGATIVE_INFINITY)));
        StringToNumberParserTestHarness.assertFalse((String)"invalid positive double infinity", (boolean)this.assertValid(new Double(Double.POSITIVE_INFINITY)));
        StringToNumberParserTestHarness.assertFalse((String)"invalid double NaN", (boolean)this.assertValid(new Double(Double.NaN)));
        StringToNumberParserTestHarness.assertTrue((String)"valid BigInteger", (boolean)this.assertValid(BigInteger.valueOf(1L)));
        BigDecimal bigDecimalMin = new BigDecimal(min.doubleValue());
        bigDecimalMin = bigDecimalMin.subtract(new BigDecimal(1.0));
        StringToNumberParserTestHarness.assertFalse((String)"invalid BigInteger min", (boolean)this.assertValid(bigDecimalMin.toBigInteger()));
        BigDecimal bigDecimalMax = new BigDecimal(max.doubleValue());
        bigDecimalMax = bigDecimalMax.add(new BigDecimal(1.0));
        StringToNumberParserTestHarness.assertFalse((String)"invalid BigInteger max", (boolean)this.assertValid(bigDecimalMax.toBigInteger()));
        StringToNumberParserTestHarness.assertTrue((String)"valid BigDecimal", (boolean)this.assertValid(new BigDecimal(1.0)));
        StringToNumberParserTestHarness.assertFalse((String)"invalid BigDecimal min", (boolean)this.assertValid(bigDecimalMin));
        StringToNumberParserTestHarness.assertFalse((String)"invalid BigDecimal max", (boolean)this.assertValid(bigDecimalMax));
        class MyNumber
        extends Number {
            double value;
            int count;
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StringToNumberParserTestHarness this$0;

            MyNumber(StringToNumberParserTestHarness stringToNumberParserTestHarness, double value) {
                this.this$0 = stringToNumberParserTestHarness;
                this.value = value;
            }

            public double doubleValue() {
                ++this.count;
                return this.value;
            }

            public float floatValue() {
                return 0.0f;
            }

            public int intValue() {
                return 0;
            }

            public long longValue() {
                return 0L;
            }
        }
        MyNumber number = new MyNumber(this, 1.0);
        StringToNumberParserTestHarness.assertEquals((int)0, (int)number.count);
        StringToNumberParserTestHarness.assertTrue((boolean)StringToNumberParser.inIntegerRange((Number)number));
        StringToNumberParserTestHarness.assertTrue((String)"double value retrieved", (number.count > 0 ? 1 : 0) != 0);
    }
}

