/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.StringToShortConverter;

public class StringToShortConverterTest
extends TestCase {
    private NumberFormat numberFormat;
    private StringToShortConverter converter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.converter = StringToShortConverter.toShort((NumberFormat)this.numberFormat, (boolean)false);
    }

    public void testConvertsToShort() throws Exception {
        Short value = new Short(1);
        Short result = (Short)this.converter.convert((Object)this.numberFormat.format((Object)value));
        StringToShortConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testConvertsToShortPrimitive() throws Exception {
        this.converter = StringToShortConverter.toShort((NumberFormat)this.numberFormat, (boolean)true);
        Short value = new Short(1);
        Short result = (Short)this.converter.convert((Object)this.numberFormat.format((Object)value));
        StringToShortConverterTest.assertEquals((Object)value, (Object)result);
    }

    public void testFromTypeIsString() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToShortConverterTest.assertEquals((Object)clazz, (Object)this.converter.getFromType());
    }

    public void testToTypeIsShort() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToShortConverterTest.assertEquals((Object)clazz, (Object)this.converter.getToType());
    }

    public void testToTypeIsShortPrimitive() throws Exception {
        this.converter = StringToShortConverter.toShort((boolean)true);
        StringToShortConverterTest.assertEquals(Short.TYPE, (Object)this.converter.getToType());
    }

    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        StringToShortConverterTest.assertNull((Object)this.converter.convert((Object)""));
    }

    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        try {
            this.converter.convert((Object)new Integer(1));
            StringToShortConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

