/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.internal.databinding.observable.MapEntryObservableValue;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.ObservableStaleContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class MapEntryObservableValueTest
extends AbstractDefaultRealmTestCase
implements IValueChangeListener {
    private static final String VALUE1 = "Value1";
    private static final String VALUE2 = "Value2";
    private final Object key = "mapKey";
    private IObservableMap map;
    private ValueDiff diff;
    private MapEntryObservableValue observedValue;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        this.map = new WritableMap();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.observedValue = (MapEntryObservableValue)Observables.observeMapEntry((IObservableMap)this.map, (Object)this.key, (Object)clazz);
        this.observedValue.addValueChangeListener((IValueChangeListener)this);
    }

    public void handleValueChange(ValueChangeEvent p_event) {
        this.diff = p_event.diff;
    }

    public void testNullValue() {
        this.map.put(this.key, null);
        MapEntryObservableValueTest.assertNull((Object)this.diff);
        MapEntryObservableValueTest.assertNull((Object)this.observedValue.getValue());
        this.map.put(this.key, null);
        MapEntryObservableValueTest.assertNull((Object)this.diff);
        MapEntryObservableValueTest.assertNull((Object)this.observedValue.getValue());
        this.map.remove(this.key);
        MapEntryObservableValueTest.assertNull((Object)this.diff);
        MapEntryObservableValueTest.assertNull((Object)this.observedValue.getValue());
    }

    public void testNonNullValue() {
        this.map.put(this.key, (Object)VALUE1);
        MapEntryObservableValueTest.assertNotNull((Object)this.diff);
        MapEntryObservableValueTest.assertNull((Object)this.diff.getOldValue());
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.diff.getNewValue());
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.observedValue.getValue());
        this.diff = null;
        this.map.put(this.key, (Object)VALUE2);
        MapEntryObservableValueTest.assertNotNull((Object)this.diff);
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.diff.getOldValue());
        MapEntryObservableValueTest.assertSame((Object)VALUE2, (Object)this.diff.getNewValue());
        MapEntryObservableValueTest.assertSame((Object)VALUE2, (Object)this.observedValue.getValue());
    }

    public void testTransitionBetweenNullAndNonNull() {
        this.map.put(this.key, null);
        this.diff = null;
        this.map.put(this.key, (Object)VALUE1);
        MapEntryObservableValueTest.assertNotNull((Object)this.diff);
        MapEntryObservableValueTest.assertNull((Object)this.diff.getOldValue());
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.diff.getNewValue());
        this.diff = null;
        this.map.put(this.key, null);
        MapEntryObservableValueTest.assertNotNull((Object)this.diff);
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.diff.getOldValue());
        MapEntryObservableValueTest.assertNull((Object)this.diff.getNewValue());
    }

    public void testRemoveKey() {
        this.map.put(this.key, (Object)VALUE1);
        this.diff = null;
        this.map.remove(this.key);
        MapEntryObservableValueTest.assertNotNull((Object)this.diff);
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.diff.getOldValue());
        MapEntryObservableValueTest.assertNull((Object)this.diff.getNewValue());
    }

    public void testGetAndSetValue() {
        this.observedValue.setValue(null);
        MapEntryObservableValueTest.assertNull((Object)this.observedValue.getValue());
        MapEntryObservableValueTest.assertNull((Object)this.diff);
        this.observedValue.setValue((Object)VALUE1);
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.observedValue.getValue());
        MapEntryObservableValueTest.assertNotNull((Object)this.diff);
        MapEntryObservableValueTest.assertNull((Object)this.diff.getOldValue());
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.diff.getNewValue());
        this.diff = null;
        this.observedValue.setValue((Object)VALUE2);
        MapEntryObservableValueTest.assertSame((Object)VALUE2, (Object)this.observedValue.getValue());
        MapEntryObservableValueTest.assertNotNull((Object)this.diff);
        MapEntryObservableValueTest.assertSame((Object)VALUE1, (Object)this.diff.getOldValue());
        MapEntryObservableValueTest.assertSame((Object)VALUE2, (Object)this.diff.getNewValue());
    }

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.MapEntryObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.MapEntryObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        suite.addTest(ObservableStaleContractTest.suite((IObservableContractDelegate)new Delegate()));
        return suite;
    }

    private static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Object valueType = new Object();

        private Delegate() {
        }

        public IObservableValue createObservableValue(Realm realm) {
            WritableMap map = new WritableMap(realm);
            Object key = new Object();
            map.put(key, new Object());
            return new MapEntryObservableValueStub(map, key, this.valueType);
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }

        public Object getValueType(IObservableValue observable) {
            return this.valueType;
        }

        public void change(IObservable observable) {
            MapEntryObservableValueStub mapEntryValue = (MapEntryObservableValueStub)observable;
            mapEntryValue.map.put(mapEntryValue.key, this.createValue((IObservableValue)mapEntryValue));
        }

        public void setStale(IObservable observable, boolean stale) {
            MapEntryObservableValueStub mapEntryValue = (MapEntryObservableValueStub)observable;
            mapEntryValue.map.setStale(stale);
        }
    }

    private static class MapEntryObservableValueStub
    extends MapEntryObservableValue {
        WritableMap map;
        Object key;

        MapEntryObservableValueStub(WritableMap map, Object key, Object valueType) {
            super((IObservableMap)map, key, valueType);
            this.map = map;
            this.key = key;
        }
    }
}

