/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class UnmodifiableObservableListTest
extends AbstractDefaultRealmTestCase {
    IObservableList unmodifiable;
    ObservableList mutable;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.mutable = new MutableObservableList(list, clazz);
        this.unmodifiable = Observables.unmodifiableObservableList((IObservableList)this.mutable);
    }

    public void testFiresChangeEvents() throws Exception {
        ChangeEventTracker mutableListener = new ChangeEventTracker();
        ChangeEventTracker unmodifiableListener = new ChangeEventTracker();
        this.mutable.addChangeListener((IChangeListener)mutableListener);
        this.unmodifiable.addChangeListener((IChangeListener)unmodifiableListener);
        UnmodifiableObservableListTest.assertEquals((int)0, (int)mutableListener.count);
        UnmodifiableObservableListTest.assertEquals((int)0, (int)unmodifiableListener.count);
        this.mutable.add((Object)"3");
        UnmodifiableObservableListTest.assertEquals((int)1, (int)mutableListener.count);
        UnmodifiableObservableListTest.assertEquals((int)1, (int)unmodifiableListener.count);
    }

    public void testFiresListChangeEvents() throws Exception {
        ListChangeEventTracker mutableListener = new ListChangeEventTracker();
        ListChangeEventTracker unmodifiableListener = new ListChangeEventTracker();
        this.mutable.addListChangeListener((IListChangeListener)mutableListener);
        this.unmodifiable.addListChangeListener((IListChangeListener)unmodifiableListener);
        UnmodifiableObservableListTest.assertEquals((int)0, (int)mutableListener.count);
        UnmodifiableObservableListTest.assertEquals((int)0, (int)unmodifiableListener.count);
        String element = "3";
        this.mutable.add((Object)element);
        UnmodifiableObservableListTest.assertEquals((int)1, (int)mutableListener.count);
        UnmodifiableObservableListTest.assertEquals((Object)this.mutable, (Object)mutableListener.event.getObservableList());
        UnmodifiableObservableListTest.assertEquals((int)1, (int)mutableListener.event.diff.getDifferences().length);
        ListDiffEntry difference = mutableListener.event.diff.getDifferences()[0];
        UnmodifiableObservableListTest.assertEquals((Object)element, (Object)difference.getElement());
        UnmodifiableObservableListTest.assertTrue((boolean)difference.isAddition());
        UnmodifiableObservableListTest.assertEquals((int)3, (int)this.mutable.size());
        UnmodifiableObservableListTest.assertEquals((int)1, (int)unmodifiableListener.count);
        UnmodifiableObservableListTest.assertEquals((Object)this.unmodifiable, (Object)unmodifiableListener.event.getObservableList());
        UnmodifiableObservableListTest.assertEquals((int)1, (int)unmodifiableListener.event.diff.getDifferences().length);
        difference = unmodifiableListener.event.diff.getDifferences()[0];
        UnmodifiableObservableListTest.assertEquals((Object)element, (Object)difference.getElement());
        UnmodifiableObservableListTest.assertTrue((boolean)difference.isAddition());
        UnmodifiableObservableListTest.assertEquals((int)3, (int)this.unmodifiable.size());
    }

    public void testFiresStaleEvents() throws Exception {
        StaleEventTracker mutableListener = new StaleEventTracker();
        StaleEventTracker unmodifiableListener = new StaleEventTracker();
        this.mutable.addStaleListener((IStaleListener)mutableListener);
        this.unmodifiable.addStaleListener((IStaleListener)unmodifiableListener);
        UnmodifiableObservableListTest.assertEquals((int)0, (int)mutableListener.count);
        UnmodifiableObservableListTest.assertEquals((int)0, (int)unmodifiableListener.count);
        this.mutable.setStale(true);
        UnmodifiableObservableListTest.assertEquals((int)1, (int)mutableListener.count);
        UnmodifiableObservableListTest.assertEquals((Object)this.mutable, (Object)mutableListener.event.getObservable());
        UnmodifiableObservableListTest.assertTrue((boolean)this.mutable.isStale());
        UnmodifiableObservableListTest.assertEquals((int)1, (int)unmodifiableListener.count);
        UnmodifiableObservableListTest.assertEquals((Object)this.unmodifiable, (Object)unmodifiableListener.event.getObservable());
        UnmodifiableObservableListTest.assertTrue((boolean)this.unmodifiable.isStale());
    }

    public void testIsStale() throws Exception {
        UnmodifiableObservableListTest.assertFalse((boolean)this.mutable.isStale());
        UnmodifiableObservableListTest.assertFalse((boolean)this.unmodifiable.isStale());
        this.mutable.setStale(true);
        UnmodifiableObservableListTest.assertTrue((boolean)this.mutable.isStale());
        UnmodifiableObservableListTest.assertTrue((boolean)this.unmodifiable.isStale());
    }

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.UnmodifiableObservableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.UnmodifiableObservableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(ObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Object elementType = new Object();

        private Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableList backingList = new WritableList(realm, new ArrayList(), this.elementType);
            UnmodifiableObservableListStub result = new UnmodifiableObservableListStub((IObservableList)backingList);
            int i = 0;
            while (i < elementCount) {
                backingList.add(this.createElement((IObservableCollection)result));
                ++i;
            }
            return result;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            UnmodifiableObservableListStub unmodifiableList = (UnmodifiableObservableListStub)observable;
            IObservableList wrappedList = unmodifiableList.wrappedList;
            wrappedList.add(this.createElement((IObservableCollection)unmodifiableList));
        }
    }

    private static class MutableObservableList
    extends ObservableList {
        public MutableObservableList(List wrappedList, Object elementType) {
            super(wrappedList, elementType);
        }

        public boolean add(Object o) {
            boolean result = this.wrappedList.add(o);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)(this.wrappedList.size() - 1), (boolean)true, (Object)o)));
            return result;
        }
    }

    private static class UnmodifiableObservableListStub
    extends UnmodifiableObservableList {
        IObservableList wrappedList;

        UnmodifiableObservableListStub(IObservableList wrappedList) {
            super(wrappedList);
            this.wrappedList = wrappedList;
        }
    }
}

