/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableSet;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.SetChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class UnmodifiableObservableSetTest
extends AbstractDefaultRealmTestCase {
    UnmodifiableObservableSet unmodifiable;
    MutableObservableSet mutable;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.mutable = new MutableObservableSet(set, clazz);
        this.unmodifiable = (UnmodifiableObservableSet)Observables.unmodifiableObservableSet((IObservableSet)this.mutable);
    }

    public void testFiresChangeEvents() throws Exception {
        ChangeEventTracker mutableListener = new ChangeEventTracker();
        ChangeEventTracker unmodifiableListener = new ChangeEventTracker();
        this.mutable.addChangeListener((IChangeListener)mutableListener);
        this.unmodifiable.addChangeListener((IChangeListener)unmodifiableListener);
        UnmodifiableObservableSetTest.assertEquals((int)0, (int)mutableListener.count);
        UnmodifiableObservableSetTest.assertEquals((int)0, (int)unmodifiableListener.count);
        this.mutable.add("3");
        UnmodifiableObservableSetTest.assertEquals((int)1, (int)mutableListener.count);
        UnmodifiableObservableSetTest.assertEquals((int)1, (int)unmodifiableListener.count);
    }

    public void testFiresSetChangeEvents() throws Exception {
        SetChangeEventTracker mutableListener = new SetChangeEventTracker();
        SetChangeEventTracker unmodifiableListener = new SetChangeEventTracker();
        this.mutable.addSetChangeListener((ISetChangeListener)mutableListener);
        this.unmodifiable.addSetChangeListener((ISetChangeListener)unmodifiableListener);
        UnmodifiableObservableSetTest.assertEquals((int)0, (int)mutableListener.count);
        UnmodifiableObservableSetTest.assertEquals((int)0, (int)unmodifiableListener.count);
        String element = "3";
        this.mutable.add(element);
        UnmodifiableObservableSetTest.assertEquals((int)1, (int)mutableListener.count);
        UnmodifiableObservableSetTest.assertEquals((Object)((Object)this.mutable), (Object)mutableListener.event.getObservableSet());
        UnmodifiableObservableSetTest.assertEquals((int)1, (int)mutableListener.event.diff.getAdditions().size());
        Object addition = mutableListener.event.diff.getAdditions().toArray()[0];
        UnmodifiableObservableSetTest.assertEquals((Object)element, (Object)addition);
        UnmodifiableObservableSetTest.assertEquals((int)3, (int)this.mutable.size());
        UnmodifiableObservableSetTest.assertEquals((int)1, (int)unmodifiableListener.count);
        UnmodifiableObservableSetTest.assertEquals((Object)this.unmodifiable, (Object)unmodifiableListener.event.getObservableSet());
        UnmodifiableObservableSetTest.assertEquals((int)1, (int)unmodifiableListener.event.diff.getAdditions().size());
        addition = unmodifiableListener.event.diff.getAdditions().toArray()[0];
        UnmodifiableObservableSetTest.assertEquals((Object)element, (Object)addition);
        UnmodifiableObservableSetTest.assertEquals((int)3, (int)this.unmodifiable.size());
    }

    public void testFiresStaleEvents() throws Exception {
        StaleEventTracker mutableListener = new StaleEventTracker();
        StaleEventTracker unmodifiableListener = new StaleEventTracker();
        this.mutable.addStaleListener((IStaleListener)mutableListener);
        this.unmodifiable.addStaleListener((IStaleListener)unmodifiableListener);
        UnmodifiableObservableSetTest.assertEquals((int)0, (int)mutableListener.count);
        UnmodifiableObservableSetTest.assertEquals((int)0, (int)unmodifiableListener.count);
        this.mutable.setStale(true);
        UnmodifiableObservableSetTest.assertEquals((int)1, (int)mutableListener.count);
        UnmodifiableObservableSetTest.assertEquals((Object)((Object)this.mutable), (Object)mutableListener.event.getObservable());
        UnmodifiableObservableSetTest.assertTrue((boolean)this.mutable.isStale());
        UnmodifiableObservableSetTest.assertEquals((int)1, (int)unmodifiableListener.count);
        UnmodifiableObservableSetTest.assertEquals((Object)this.unmodifiable, (Object)unmodifiableListener.event.getObservable());
        UnmodifiableObservableSetTest.assertTrue((boolean)this.unmodifiable.isStale());
    }

    public void testIsStale() throws Exception {
        UnmodifiableObservableSetTest.assertFalse((boolean)this.mutable.isStale());
        UnmodifiableObservableSetTest.assertFalse((boolean)this.unmodifiable.isStale());
        this.mutable.setStale(true);
        UnmodifiableObservableSetTest.assertTrue((boolean)this.mutable.isStale());
        UnmodifiableObservableSetTest.assertTrue((boolean)this.unmodifiable.isStale());
    }

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.UnmodifiableObservableSetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.UnmodifiableObservableSetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(ObservableCollectionContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Object elementType = new Object();

        private Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableSet backingList = new WritableSet(realm, new HashSet(), this.elementType);
            UnmodifiableObservableSetStub result = new UnmodifiableObservableSetStub((IObservableSet)backingList);
            int i = 0;
            while (i < elementCount) {
                backingList.add(this.createElement((IObservableCollection)result));
                ++i;
            }
            return result;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            UnmodifiableObservableSetStub unmodifiableList = (UnmodifiableObservableSetStub)observable;
            IObservableSet wrappedList = unmodifiableList.wrappedSet;
            wrappedList.add(this.createElement((IObservableCollection)unmodifiableList));
        }
    }

    private static class MutableObservableSet
    extends ObservableSet {
        public MutableObservableSet(Set wrappedSet, Object elementType) {
            super(wrappedSet, elementType);
        }

        public boolean add(Object o) {
            boolean result = this.wrappedSet.add(o);
            if (result) {
                this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), (Set)Collections.EMPTY_SET));
            }
            return result;
        }
    }

    private static class UnmodifiableObservableSetStub
    extends UnmodifiableObservableSet {
        IObservableSet wrappedSet;

        UnmodifiableObservableSetStub(IObservableSet wrappedSet) {
            super(wrappedSet);
            this.wrappedSet = wrappedSet;
        }
    }
}

