/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableMap;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.tests.internal.databinding.observable.masterdetail.DetailObservableMapTest;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DetailObservableMapTest
extends AbstractDefaultRealmTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void testKeyValueTypeNull() throws Exception {
        WritableValue observableValue = new WritableValue();
        WritableMapFactory factory = new WritableMapFactory();
        DetailObservableMap detailObservable = new DetailObservableMap((IObservableFactory)factory, (IObservableValue)observableValue, null, null);
        DetailObservableMapTest.assertNull((Object)detailObservable.getKeyType());
        DetailObservableMapTest.assertNull((Object)detailObservable.getValueType());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.keyType = clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.valueType = clazz2;
        observableValue.setValue(new Object());
        DetailObservableMapTest.assertNull((String)"key type not null", (Object)detailObservable.getKeyType());
        DetailObservableMapTest.assertNull((String)"value type not null", (Object)detailObservable.getValueType());
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.keyType = clazz3;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.valueType = clazz4;
        observableValue.setValue(new Object());
        DetailObservableMapTest.assertNull((String)"key type not null", (Object)detailObservable.getKeyType());
        DetailObservableMapTest.assertNull((String)"value type not null", (Object)detailObservable.getValueType());
    }

    public void testKeyValueTypeNotNull() throws Exception {
        Class<?> clazz;
        WritableValue observableValue = new WritableValue();
        WritableMapFactory factory = new WritableMapFactory();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DetailObservableMap detailObservable = new DetailObservableMap((IObservableFactory)factory, (IObservableValue)observableValue, (Object)clazz2, (Object)clazz);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DetailObservableMapTest.assertEquals((Object)clazz3, (Object)detailObservable.getKeyType());
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DetailObservableMapTest.assertEquals((Object)clazz4, (Object)detailObservable.getValueType());
        try {
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            factory.keyType = clazz5;
            Class<?> clazz6 = class$1;
            if (clazz6 == null) {
                try {
                    clazz6 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            factory.valueType = clazz6;
            observableValue.setValue(new Object());
            DetailObservableMapTest.fail((String)"if an element type is set this cannot be changed");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testMasterNotDisposedWhenDetailDisposed() {
        class OuterObservable
        extends WritableValue {
            boolean disposed;
            final /* synthetic */ DetailObservableMapTest this$0;

            OuterObservable(DetailObservableMapTest detailObservableMapTest) {
                this.this$0 = detailObservableMapTest;
                this.disposed = false;
            }

            public synchronized void dispose() {
                this.disposed = true;
                super.dispose();
            }
        }
        OuterObservable outerObservable = new OuterObservable(this);
        WritableMapFactory factory = new WritableMapFactory();
        DetailObservableMap detailObservable = new DetailObservableMap((IObservableFactory)factory, (IObservableValue)outerObservable, null, null);
        DetailObservableMapTest.assertFalse((boolean)outerObservable.disposed);
        detailObservable.dispose();
        DetailObservableMapTest.assertFalse((boolean)outerObservable.disposed);
    }

    public void testDisposeMasterDisposesDetail() {
        WritableValue master = new WritableValue();
        WritableMapFactory factory = new WritableMapFactory();
        master.setValue((Object)"");
        IObservableMap detailObservable = MasterDetailObservables.detailMap((IObservableValue)master, (IObservableFactory)factory, null, null);
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)detailObservable);
        master.dispose();
        DetailObservableMapTest.assertEquals((int)1, (int)tracker.count);
        DetailObservableMapTest.assertTrue((boolean)detailObservable.isDisposed());
    }

    public void testDisposeWhileFiringEvents() {
        WritableValue master = new WritableValue();
        WritableMapFactory factory = new WritableMapFactory();
        master.setValue((Object)"");
        final IObservableMap[] detailObservable = new IObservableMap[1];
        master.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                detailObservable[0].dispose();
            }
        });
        detailObservable[0] = MasterDetailObservables.detailMap((IObservableValue)master, (IObservableFactory)factory, null, null);
        master.setValue((Object)"New Value");
    }

    private static class WritableMapFactory
    implements IObservableFactory {
        Object keyType;
        Object valueType;

        private WritableMapFactory() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.keyType = clazz;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.valueType = clazz2;
        }

        public IObservable createObservable(Object target) {
            return new WritableMap(this.keyType, this.valueType);
        }
    }
}

