/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableSet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.tests.internal.databinding.observable.masterdetail.DetailObservableSetTest;
import org.eclipse.jface.databinding.conformance.MutableObservableSetContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DetailObservableSetTest
extends AbstractDefaultRealmTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void testElementTypeNull() throws Exception {
        HashSet hashSet = new HashSet();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableValue observableValue = new WritableValue((Object)new WritableSet(hashSet, (Object)clazz), null);
        WritableSetFactory factory = new WritableSetFactory();
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)observableValue, null);
        DetailObservableSetTest.assertNull((Object)detailObservable.getElementType());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.type = clazz2;
        List<Object> list = Arrays.asList(new Object());
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        observableValue.setValue((Object)new WritableSet(list, (Object)clazz3));
        DetailObservableSetTest.assertNull((String)"element type not null", (Object)detailObservable.getElementType());
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.type = clazz4;
        List<String> list2 = Arrays.asList("1");
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        observableValue.setValue((Object)new WritableSet(list2, (Object)clazz5));
        DetailObservableSetTest.assertNull((String)"element type not null", (Object)detailObservable.getElementType());
    }

    public void testElementTypeNotNull() throws Exception {
        HashSet hashSet = new HashSet();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableValue observableValue = new WritableValue((Object)new WritableSet(hashSet, (Object)clazz), null);
        WritableSetFactory factory = new WritableSetFactory();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)observableValue, (Object)clazz2);
        DetailObservableSetTest.assertEquals((Object)factory.type, (Object)detailObservable.getElementType());
        try {
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            factory.type = clazz3;
            List<Object> list = Arrays.asList(new Object());
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            observableValue.setValue((Object)new WritableSet(list, (Object)clazz4));
            DetailObservableSetTest.fail((String)"if an element type is set this cannot be changed");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testMasterNotDisposedWhenDetailDisposed() {
        class OuterObservable
        extends WritableValue {
            boolean disposed;
            final /* synthetic */ DetailObservableSetTest this$0;

            OuterObservable(DetailObservableSetTest detailObservableSetTest) {
                this.this$0 = detailObservableSetTest;
                this.disposed = false;
            }

            public synchronized void dispose() {
                this.disposed = true;
                super.dispose();
            }
        }
        OuterObservable outerObservable = new OuterObservable(this);
        WritableSetFactory factory = new WritableSetFactory();
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)outerObservable, null);
        DetailObservableSetTest.assertFalse((boolean)outerObservable.disposed);
        detailObservable.dispose();
        DetailObservableSetTest.assertFalse((boolean)outerObservable.disposed);
    }

    public void testDisposeMasterDisposesDetail() {
        WritableValue master = new WritableValue();
        WritableSetFactory factory = new WritableSetFactory();
        master.setValue((Object)"");
        IObservableSet detailObservable = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)factory, null);
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)detailObservable);
        master.dispose();
        DetailObservableSetTest.assertEquals((int)1, (int)tracker.count);
        DetailObservableSetTest.assertTrue((boolean)detailObservable.isDisposed());
    }

    public void testDisposeWhileFiringEvents() {
        WritableValue master = new WritableValue();
        WritableSetFactory factory = new WritableSetFactory();
        master.setValue((Object)"");
        final IObservableSet[] detailObservable = new IObservableSet[1];
        master.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                detailObservable[0].dispose();
            }
        });
        detailObservable[0] = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)factory, null);
        master.setValue((Object)"New Value");
    }

    public static Test suite() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.masterdetail.DetailObservableSetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.masterdetail.DetailObservableSetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(MutableObservableSetContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Object elementType;

        Delegate() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.elementType = clazz;
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            Integer n = new Integer(elementCount);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            WritableValue master = new WritableValue(realm, (Object)n, (Object)clazz);
            FactoryStub factory = new FactoryStub(realm, this.elementType);
            return new DetailObservableSetStub(factory, (IObservableValue)master, this.elementType);
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            IObservableValue master = ((DetailObservableSetStub)observable).master;
            master.setValue((Object)new Integer((Integer)master.getValue() + 1));
        }
    }

    static class DetailObservableSetStub
    extends DetailObservableSet {
        IObservableValue master;

        DetailObservableSetStub(IObservableFactory factory, IObservableValue master, Object elementType) {
            super(factory, master, elementType);
            this.master = master;
        }
    }

    static class FactoryStub
    implements IObservableFactory {
        private Realm realm;
        private Object elementType;
        Object type;

        FactoryStub(Realm realm, Object elementType) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.type = clazz;
            this.realm = realm;
            this.elementType = elementType;
        }

        public IObservable createObservable(Object target) {
            int elementCount = (Integer)target;
            HashSet<Object> wrappedSet = new HashSet<Object>();
            int i = 0;
            while (i < elementCount) {
                wrappedSet.add(new Object());
                ++i;
            }
            return new WritableSet(this.realm, wrappedSet, this.elementType);
        }
    }

    private static class WritableSetFactory
    implements IObservableFactory {
        Object type;

        private WritableSetFactory() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.type = clazz;
        }

        public IObservable createObservable(Object target) {
            return new WritableSet(new HashSet(), this.type);
        }
    }
}

