/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableValue;
import org.eclipse.core.tests.internal.databinding.observable.masterdetail.DetailObservableValueTest;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DetailObservableValueTest
extends AbstractDefaultRealmTestCase {
    private WritableValue outerObservable;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void setUp() throws Exception {
        super.setUp();
        this.outerObservable = new WritableValue();
    }

    public void testSetValue() throws Exception {
        WritableValueFactory factory = new WritableValueFactory();
        this.outerObservable.setValue((Object)"");
        IObservableValue detailObservable = MasterDetailObservables.detailValue((IObservableValue)this.outerObservable, (IObservableFactory)factory, null);
        WritableValue innerObservable = factory.innerObservable;
        Object value = new Object();
        DetailObservableValueTest.assertFalse((boolean)value.equals(innerObservable.getValue()));
        detailObservable.setValue(value);
        DetailObservableValueTest.assertEquals((String)"inner value", (Object)value, (Object)innerObservable.getValue());
    }

    public void testGetValueType() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DetailObservableValue detailObservable = new DetailObservableValue((IObservableValue)this.outerObservable, null, (Object)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DetailObservableValueTest.assertEquals((Object)clazz2, (Object)detailObservable.getValueType());
    }

    public void testGetValueTypeNullValueType() throws Exception {
        WritableValueFactory factory = new WritableValueFactory();
        DetailObservableValue detailObservable = new DetailObservableValue((IObservableValue)this.outerObservable, (IObservableFactory)factory, null);
        DetailObservableValueTest.assertNull((Object)detailObservable.getValueType());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.type = clazz;
        this.outerObservable.setValue((Object)"1");
        DetailObservableValueTest.assertNull((String)"value type should be ignored", (Object)detailObservable.getValueType());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.type = clazz2;
        this.outerObservable.setValue((Object)"2");
        DetailObservableValueTest.assertNull((String)"value type should be ignored", (Object)detailObservable.getValueType());
    }

    public void testMasterNotDisposedWhenDetailDisposed() {
        class OuterObservable
        extends WritableValue {
            boolean disposed;
            final /* synthetic */ DetailObservableValueTest this$0;

            OuterObservable(DetailObservableValueTest detailObservableValueTest) {
                this.this$0 = detailObservableValueTest;
                this.disposed = false;
            }

            public synchronized void dispose() {
                this.disposed = true;
                super.dispose();
            }
        }
        OuterObservable outerObservable = new OuterObservable(this);
        WritableValueFactory factory = new WritableValueFactory();
        DetailObservableValue detailObservable = new DetailObservableValue((IObservableValue)outerObservable, (IObservableFactory)factory, null);
        DetailObservableValueTest.assertFalse((boolean)outerObservable.disposed);
        detailObservable.dispose();
        DetailObservableValueTest.assertFalse((boolean)outerObservable.disposed);
    }

    public void testDisposeMasterDisposesDetail() {
        WritableValue master = new WritableValue();
        WritableValueFactory factory = new WritableValueFactory();
        master.setValue((Object)"");
        IObservableValue detailObservable = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)factory, null);
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)detailObservable);
        master.dispose();
        DetailObservableValueTest.assertEquals((int)1, (int)tracker.count);
        DetailObservableValueTest.assertTrue((boolean)detailObservable.isDisposed());
    }

    public void testDisposeWhileFiringEvents() {
        WritableValue master = new WritableValue();
        WritableValueFactory factory = new WritableValueFactory();
        master.setValue((Object)"");
        final IObservableValue[] detailObservable = new IObservableValue[1];
        master.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                detailObservable[0].dispose();
            }
        });
        detailObservable[0] = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)factory, null);
        master.setValue((Object)"New Value");
    }

    public static Test suite() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.masterdetail.DetailObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.masterdetail.DetailObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    private static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Object valueType;
        private Realm previousRealm;

        private Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.valueType = new Object();
            this.previousRealm = Realm.getDefault();
            RealmTester.setDefault((Realm)new CurrentRealm());
        }

        public void tearDown() {
            RealmTester.setDefault((Realm)this.previousRealm);
            super.tearDown();
        }

        public IObservableValue createObservableValue(Realm realm) {
            WritableValueFactory valueFactory = new WritableValueFactory();
            valueFactory.realm = realm;
            valueFactory.type = this.valueType;
            WritableValue masterObservableValue = new WritableValue(realm, new Object(), null);
            return new DetailObservableValueStub((IObservableValue)masterObservableValue, valueFactory, this.valueType);
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }

        public Object getValueType(IObservableValue observable) {
            return this.valueType;
        }

        public void change(IObservable observable) {
            DetailObservableValueStub value = (DetailObservableValueStub)observable;
            value.outerObservableValue.setValue(this.createValue((IObservableValue)value));
        }
    }

    private static class DetailObservableValueStub
    extends DetailObservableValue {
        IObservableValue outerObservableValue;

        DetailObservableValueStub(IObservableValue outerObservableValue, IObservableFactory valueFactory, Object detailType) {
            super(outerObservableValue, valueFactory, detailType);
            this.outerObservableValue = outerObservableValue;
        }
    }

    static class WritableValueFactory
    implements IObservableFactory {
        Realm realm;
        WritableValue innerObservable;
        Object type;

        WritableValueFactory() {
        }

        public IObservable createObservable(Object target) {
            this.innerObservable = new WritableValue(this.realm == null ? Realm.getDefault() : this.realm, target, this.type);
            return this.innerObservable;
        }
    }
}

