/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.ListDetailValueObservableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ListDetailValueObservableListTest
extends AbstractDefaultRealmTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.masterdetail.ListDetailValueObservableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.masterdetail.ListDetailValueObservableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(ObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    public void testUnmodifiability() {
        WritableList masterObservableList = new WritableList();
        masterObservableList.add((Object)new SimplePerson());
        masterObservableList.add((Object)new SimplePerson());
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterObservableList, BeansObservables.valueFactory((String)"name"), null);
        try {
            ldol.add((Object)"name");
            ListDetailValueObservableListTest.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            ldol.remove(masterObservableList.get(0));
            ListDetailValueObservableListTest.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            ldol.removeAll(Collections.singleton(masterObservableList.get(0)));
            ListDetailValueObservableListTest.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            ldol.retainAll((Collection)Collections.EMPTY_LIST);
            ListDetailValueObservableListTest.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            ldol.move(0, 1);
            ListDetailValueObservableListTest.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testGetElementType() {
        WritableList writableList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)writableList, iObservableFactory, (Object)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableListTest.assertSame((Object)clazz2, (Object)ldol.getElementType());
    }

    public void testGetObserved() {
        WritableList masterList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, iObservableFactory, (Object)clazz);
        ListDetailValueObservableListTest.assertSame((Object)masterList, (Object)ldol.getObserved());
    }

    public void testMasterListInitiallyNotEmpty() {
        WritableList masterList = new WritableList();
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterList.add((Object)person);
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, iObservableFactory, (Object)clazz);
        ListDetailValueObservableListTest.assertEquals((int)masterList.size(), (int)ldol.size());
        ListDetailValueObservableListTest.assertEquals((Object)person.getName(), (Object)ldol.get(0));
    }

    public void testAddRemove() {
        WritableList masterList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, iObservableFactory, (Object)clazz);
        ListDetailValueObservableListTest.assertTrue((boolean)ldol.isEmpty());
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterList.add((Object)p1);
        ListDetailValueObservableListTest.assertEquals((int)masterList.size(), (int)ldol.size());
        ListDetailValueObservableListTest.assertEquals((Object)p1.getName(), (Object)ldol.get(0));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name2");
        masterList.add((Object)p2);
        ListDetailValueObservableListTest.assertEquals((int)masterList.size(), (int)ldol.size());
        ListDetailValueObservableListTest.assertEquals((Object)p2.getName(), (Object)ldol.get(1));
        masterList.remove(0);
        ListDetailValueObservableListTest.assertEquals((int)masterList.size(), (int)ldol.size());
        ListDetailValueObservableListTest.assertEquals((Object)p2.getName(), (Object)ldol.get(0));
        masterList.remove(0);
        ListDetailValueObservableListTest.assertTrue((boolean)ldol.isEmpty());
    }

    public void testChangeDetail() {
        WritableList masterList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, iObservableFactory, (Object)clazz);
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterList.add((Object)p1);
        ListDetailValueObservableListTest.assertEquals((Object)p1.getName(), (Object)ldol.get(0));
        p1.setName("name2");
        ListDetailValueObservableListTest.assertEquals((Object)p1.getName(), (Object)ldol.get(0));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name3");
        masterList.set(0, (Object)p2);
        ListDetailValueObservableListTest.assertEquals((Object)p2.getName(), (Object)ldol.get(0));
    }

    public void testSet() {
        WritableList masterList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, iObservableFactory, (Object)clazz);
        SimplePerson person = new SimplePerson();
        person.setName("name1");
        masterList.add((Object)person);
        ListDetailValueObservableListTest.assertEquals((Object)person.getName(), (Object)ldol.get(0));
        ldol.set(0, (Object)"name2");
        ListDetailValueObservableListTest.assertEquals((String)"name2", (String)person.getName());
        ListDetailValueObservableListTest.assertEquals((Object)person.getName(), (Object)ldol.get(0));
    }

    public void testDuplicateMasterElements() {
        WritableList masterList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, iObservableFactory, (Object)clazz);
        SimplePerson master = new SimplePerson();
        master.setName("name1");
        masterList.add((Object)master);
        masterList.add((Object)master);
        ListChangeEventTracker changeTracker = ListChangeEventTracker.observe((IObservableList)ldol);
        master.setName("name2");
        ListDetailValueObservableListTest.assertEquals((int)1, (int)changeTracker.count);
        ListDetailValueObservableListTest.assertEquals((int)4, (int)changeTracker.event.diff.getDifferences().length);
        this.assertReplaceDiffAt(changeTracker.event.diff, 0, 0, "name1", "name2");
        this.assertReplaceDiffAt(changeTracker.event.diff, 2, 0, "name1", "name2");
        masterList.remove((Object)master);
        ldol.set(0, (Object)"name3");
        ListDetailValueObservableListTest.assertEquals((String)"name3", (String)master.getName());
    }

    public void testDetailObservableChangeEvent() {
        WritableList masterList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, iObservableFactory, (Object)clazz);
        ListChangeEventTracker changeTracker = ListChangeEventTracker.observe((IObservableList)ldol);
        SimplePerson person = new SimplePerson();
        person.setName("old name");
        ListDetailValueObservableListTest.assertEquals((int)0, (int)changeTracker.count);
        masterList.add((Object)person);
        ListDetailValueObservableListTest.assertEquals((int)1, (int)changeTracker.count);
        ListDetailValueObservableListTest.assertEquals((int)1, (int)changeTracker.event.diff.getDifferences().length);
        ListDetailValueObservableListTest.assertTrue((boolean)changeTracker.event.diff.getDifferences()[0].isAddition());
        ListDetailValueObservableListTest.assertEquals((int)0, (int)changeTracker.event.diff.getDifferences()[0].getPosition());
        ListDetailValueObservableListTest.assertEquals((Object)person.getName(), (Object)changeTracker.event.diff.getDifferences()[0].getElement());
        person.setName("new name");
        ListDetailValueObservableListTest.assertEquals((int)2, (int)changeTracker.count);
        this.assertIsSingleReplaceDiff(changeTracker.event.diff, 0, "old name", "new name");
    }

    private void assertIsSingleReplaceDiff(ListDiff diff, int index, Object oldElement, Object newElement) {
        ListDetailValueObservableListTest.assertEquals((int)2, (int)diff.getDifferences().length);
        this.assertReplaceDiffAt(diff, 0, index, oldElement, newElement);
    }

    private void assertReplaceDiffAt(ListDiff diff, int diffOffset, int index, Object oldElement, Object newElement) {
        ListDiffEntry entry1 = diff.getDifferences()[0];
        ListDiffEntry entry2 = diff.getDifferences()[1];
        ListDetailValueObservableListTest.assertTrue((boolean)(entry1.isAddition() ^ entry2.isAddition()));
        ListDetailValueObservableListTest.assertEquals((int)index, (int)entry1.getPosition());
        ListDetailValueObservableListTest.assertEquals((int)index, (int)entry2.getPosition());
        if (entry1.isAddition()) {
            ListDetailValueObservableListTest.assertEquals((Object)oldElement, (Object)entry2.getElement());
            ListDetailValueObservableListTest.assertEquals((Object)newElement, (Object)entry1.getElement());
        } else {
            ListDetailValueObservableListTest.assertEquals((Object)oldElement, (Object)entry1.getElement());
            ListDetailValueObservableListTest.assertEquals((Object)newElement, (Object)entry2.getElement());
        }
    }

    public void testMasterNull() {
        WritableList masterObservableList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterObservableList, iObservableFactory, (Object)clazz);
        masterObservableList.add(null);
        ListDetailValueObservableListTest.assertEquals((int)1, (int)ldol.size());
        ListDetailValueObservableListTest.assertNull((Object)ldol.get(0));
    }

    public void testDetailObservableValuesAreDisposed() {
        final ArrayList detailObservables = new ArrayList();
        IObservableFactory detailValueFactory = new IObservableFactory(){

            public IObservable createObservable(Object target) {
                WritableValue detailObservable = new WritableValue();
                detailObservables.add(detailObservable);
                return detailObservable;
            }
        };
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, detailValueFactory, null);
        masterList.add(new Object());
        masterList.add(new Object());
        ListDetailValueObservableListTest.assertEquals((int)ldol.size(), (int)detailObservables.size());
        ListDetailValueObservableListTest.assertFalse((boolean)((WritableValue)detailObservables.get(0)).isDisposed());
        ListDetailValueObservableListTest.assertFalse((boolean)((WritableValue)detailObservables.get(1)).isDisposed());
        masterList.remove(1);
        ListDetailValueObservableListTest.assertFalse((boolean)((WritableValue)detailObservables.get(0)).isDisposed());
        ListDetailValueObservableListTest.assertTrue((boolean)((WritableValue)detailObservables.get(1)).isDisposed());
        ldol.dispose();
        ListDetailValueObservableListTest.assertTrue((boolean)((WritableValue)detailObservables.get(0)).isDisposed());
        ListDetailValueObservableListTest.assertTrue((boolean)((WritableValue)detailObservables.get(1)).isDisposed());
    }

    public void testDisposeOnMasterDisposed() {
        WritableList masterList = new WritableList();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, iObservableFactory, (Object)clazz);
        ListDetailValueObservableListTest.assertFalse((boolean)masterList.isDisposed());
        ListDetailValueObservableListTest.assertFalse((boolean)ldol.isDisposed());
        masterList.dispose();
        ListDetailValueObservableListTest.assertTrue((boolean)masterList.isDisposed());
        ListDetailValueObservableListTest.assertTrue((boolean)ldol.isDisposed());
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableList masterList = new WritableList(realm);
            int i = 0;
            while (i < elementCount) {
                masterList.add((Object)new SimplePerson());
                ++i;
            }
            IObservableFactory iObservableFactory = BeansObservables.valueFactory((Realm)realm, (String)"name");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new TestListDetailValueObservableList((IObservableList)masterList, iObservableFactory, clazz);
        }

        public void change(IObservable observable) {
            TestListDetailValueObservableList ldol = (TestListDetailValueObservableList)observable;
            ldol.masterList.add((Object)new SimplePerson());
        }

        public Object getElementType(IObservableCollection collection) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }

    private static class TestListDetailValueObservableList
    extends ListDetailValueObservableList {
        final IObservableList masterList;

        public TestListDetailValueObservableList(IObservableList masterList, IObservableFactory detailValueFactory, Object detailType) {
            super(masterList, detailValueFactory, detailType);
            this.masterList = masterList;
        }
    }
}

