/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.MapDetailValueObservableMap;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class MapDetailValueObservableMapTest
extends AbstractDefaultRealmTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.masterdetail.MapDetailValueObservableMapTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.observable.masterdetail.MapDetailValueObservableMapTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        return suite;
    }

    public void testGetKeyType() {
        Class<?> clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.examples.databinding.model.SimplePerson");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.examples.databinding.model.SimplePerson");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableMap writableMap = new WritableMap((Object)clazz2, (Object)clazz);
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)writableMap, iObservableFactory, (Object)clazz3);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.jface.examples.databinding.model.SimplePerson");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMapTest.assertSame((Object)clazz4, (Object)mdom.getKeyType());
    }

    public void testGetValueType() {
        WritableMap writableMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)writableMap, iObservableFactory, (Object)clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMapTest.assertSame((Object)clazz2, (Object)mdom.getValueType());
    }

    public void testGetObserved() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        MapDetailValueObservableMapTest.assertSame((Object)masterMap, (Object)mdom.getObserved());
    }

    public void testMasterSetInitiallyNotEmpty() {
        WritableMap masterMap = new WritableMap();
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterMap.put((Object)person, (Object)person);
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        MapDetailValueObservableMapTest.assertEquals((int)masterMap.size(), (int)mdom.size());
        MapDetailValueObservableMapTest.assertEquals((Object)person.getName(), (Object)mdom.get((Object)person));
    }

    public void testAddRemove() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        MapDetailValueObservableMapTest.assertTrue((boolean)mdom.isEmpty());
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterMap.put((Object)p1, (Object)p1);
        MapDetailValueObservableMapTest.assertEquals((int)masterMap.size(), (int)mdom.size());
        MapDetailValueObservableMapTest.assertEquals((Object)p1.getName(), (Object)mdom.get((Object)p1));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name2");
        masterMap.put((Object)p2, (Object)p2);
        MapDetailValueObservableMapTest.assertEquals((int)masterMap.size(), (int)mdom.size());
        MapDetailValueObservableMapTest.assertEquals((Object)p2.getName(), (Object)mdom.get((Object)p2));
        masterMap.remove((Object)p1);
        MapDetailValueObservableMapTest.assertEquals((int)masterMap.size(), (int)mdom.size());
        MapDetailValueObservableMapTest.assertEquals((Object)p2.getName(), (Object)mdom.get((Object)p2));
        masterMap.remove((Object)p2);
        MapDetailValueObservableMapTest.assertTrue((boolean)mdom.isEmpty());
    }

    public void testChangeDetail() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterMap.put((Object)p1, (Object)p1);
        MapDetailValueObservableMapTest.assertEquals((Object)p1.getName(), (Object)mdom.get((Object)p1));
        p1.setName("name2");
        MapDetailValueObservableMapTest.assertEquals((Object)p1.getName(), (Object)mdom.get((Object)p1));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name3");
        masterMap.put((Object)p1, (Object)p2);
        MapDetailValueObservableMapTest.assertEquals((Object)p2.getName(), (Object)mdom.get((Object)p1));
    }

    public void testPut() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        SimplePerson person = new SimplePerson();
        person.setName("name1");
        masterMap.put((Object)person, (Object)person);
        MapDetailValueObservableMapTest.assertEquals((Object)person.getName(), (Object)mdom.get((Object)person));
        mdom.put((Object)person, (Object)"name2");
        MapDetailValueObservableMapTest.assertEquals((String)"name2", (String)person.getName());
        MapDetailValueObservableMapTest.assertEquals((Object)person.getName(), (Object)mdom.get((Object)person));
    }

    public void testContainsValue() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterMap.put((Object)person, (Object)person);
        MapDetailValueObservableMapTest.assertTrue((boolean)mdom.containsValue((Object)person.getName()));
        masterMap.remove((Object)person);
        MapDetailValueObservableMapTest.assertFalse((boolean)mdom.containsValue((Object)person.getName()));
    }

    public void testRemove() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        SimplePerson p1 = new SimplePerson();
        SimplePerson p2 = new SimplePerson();
        masterMap.put((Object)p1, (Object)p1);
        masterMap.put((Object)p2, (Object)p2);
        MapDetailValueObservableMapTest.assertTrue((boolean)mdom.containsKey((Object)p1));
        MapDetailValueObservableMapTest.assertTrue((boolean)mdom.containsKey((Object)p2));
        mdom.remove((Object)p1);
        MapDetailValueObservableMapTest.assertFalse((boolean)mdom.containsKey((Object)p1));
        MapDetailValueObservableMapTest.assertTrue((boolean)mdom.containsKey((Object)p2));
        mdom.remove((Object)p1);
        MapDetailValueObservableMapTest.assertFalse((boolean)mdom.containsKey((Object)p1));
        MapDetailValueObservableMapTest.assertTrue((boolean)mdom.containsKey((Object)p2));
    }

    public void testDetailObservableChangeEvent() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        MapChangeEventTracker changeTracker = MapChangeEventTracker.observe((IObservableMap)mdom);
        SimplePerson person = new SimplePerson();
        person.setName("old name");
        MapDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.count);
        masterMap.put((Object)person, (Object)person);
        MapDetailValueObservableMapTest.assertEquals((int)1, (int)changeTracker.count);
        MapDetailValueObservableMapTest.assertEquals((int)1, (int)changeTracker.event.diff.getAddedKeys().size());
        MapDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.event.diff.getRemovedKeys().size());
        MapDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.event.diff.getChangedKeys().size());
        MapDetailValueObservableMapTest.assertSame((Object)person, changeTracker.event.diff.getAddedKeys().iterator().next());
        MapDetailValueObservableMapTest.assertNull((Object)changeTracker.event.diff.getOldValue((Object)person));
        MapDetailValueObservableMapTest.assertEquals((Object)"old name", (Object)changeTracker.event.diff.getNewValue((Object)person));
        person.setName("new name");
        MapDetailValueObservableMapTest.assertEquals((int)2, (int)changeTracker.count);
        MapDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.event.diff.getAddedKeys().size());
        MapDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.event.diff.getRemovedKeys().size());
        MapDetailValueObservableMapTest.assertEquals((int)1, (int)changeTracker.event.diff.getChangedKeys().size());
        MapDetailValueObservableMapTest.assertSame((Object)person, changeTracker.event.diff.getChangedKeys().iterator().next());
        MapDetailValueObservableMapTest.assertEquals((Object)"old name", (Object)changeTracker.event.diff.getOldValue((Object)person));
        MapDetailValueObservableMapTest.assertEquals((Object)"new name", (Object)changeTracker.event.diff.getNewValue((Object)person));
    }

    public void testMasterNull() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        masterMap.put(null, null);
        MapDetailValueObservableMapTest.assertEquals((int)1, (int)mdom.size());
        MapDetailValueObservableMapTest.assertNull((Object)mdom.get(null));
    }

    public void testDetailObservableValuesAreDisposed() {
        final HashMap detailObservables = new HashMap();
        IObservableFactory detailValueFactory = new IObservableFactory(){

            public IObservable createObservable(Object target) {
                WritableValue detailObservable = new WritableValue();
                detailObservables.put(target, detailObservable);
                return detailObservable;
            }
        };
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, detailValueFactory, null);
        Object master1 = new Object();
        Object master2 = new Object();
        masterMap.put(master1, master1);
        masterMap.put(master2, master2);
        MapChangeEventTracker.observe((IObservableMap)mdom);
        MapDetailValueObservableMapTest.assertEquals((int)mdom.size(), (int)detailObservables.size());
        MapDetailValueObservableMapTest.assertFalse((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        MapDetailValueObservableMapTest.assertFalse((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
        masterMap.remove(master2);
        MapDetailValueObservableMapTest.assertFalse((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        MapDetailValueObservableMapTest.assertTrue((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
        mdom.dispose();
        MapDetailValueObservableMapTest.assertTrue((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        MapDetailValueObservableMapTest.assertTrue((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
    }

    public void testDisposeOnMasterDisposed() {
        WritableMap masterMap = new WritableMap();
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((String)"name");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, iObservableFactory, (Object)clazz);
        MapDetailValueObservableMapTest.assertFalse((boolean)masterMap.isDisposed());
        MapDetailValueObservableMapTest.assertFalse((boolean)mdom.isDisposed());
        masterMap.dispose();
        MapDetailValueObservableMapTest.assertTrue((boolean)masterMap.isDisposed());
        MapDetailValueObservableMapTest.assertTrue((boolean)mdom.isDisposed());
    }
}

