/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.validation.NumberToNumberValidator;
import org.eclipse.core.runtime.IStatus;

public abstract class NumberToNumberValidatorTestHarness
extends TestCase {
    static /* synthetic */ Class class$0;

    protected abstract NumberToNumberValidator doGetToPrimitiveValidator(Class var1);

    protected abstract NumberToNumberValidator doGetToBoxedTypeValidator(Class var1);

    protected abstract Number doGetOutOfRangeNumber();

    public void testValidateNullForBoxedTypeIsOK() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IStatus status = this.doGetToBoxedTypeValidator(clazz).validate(null);
        NumberToNumberValidatorTestHarness.assertTrue((boolean)status.isOK());
    }

    public void testValidateNullForPrimitiveThrowsIllegalArgumentException() throws Exception {
        NumberToNumberValidator validator;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((validator = this.doGetToPrimitiveValidator(clazz)) == null) {
            return;
        }
        try {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.doGetToPrimitiveValidator(clazz2).validate(null);
            NumberToNumberValidatorTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testValidReturnsOK() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToNumberValidatorTestHarness.assertTrue((boolean)this.doGetToBoxedTypeValidator(clazz).validate((Object)new Integer(1)).isOK());
    }

    public void testOutOfRangeReturnsError() throws Exception {
        Number number = this.doGetOutOfRangeNumber();
        if (number == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IStatus status = this.doGetToBoxedTypeValidator(clazz).validate((Object)number);
        NumberToNumberValidatorTestHarness.assertEquals((int)4, (int)status.getSeverity());
        NumberToNumberValidatorTestHarness.assertTrue((status.getMessage() != null ? 1 : 0) != 0);
    }

    public void testValidateIncorrectTypeThrowsIllegalArgumentException() throws Exception {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.doGetToBoxedTypeValidator(clazz).validate((Object)"");
            NumberToNumberValidatorTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

