/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import com.ibm.icu.text.NumberFormat;
import junit.framework.TestCase;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;

public abstract class StringToNumberValidatorTestHarness
extends TestCase {
    private NumberFormat numberFormat;
    private IValidator validator;

    protected void setUp() throws Exception {
        super.setUp();
        this.numberFormat = this.setupNumberFormat();
        this.validator = this.setupValidator(this.numberFormat);
    }

    protected abstract NumberFormat setupNumberFormat();

    protected abstract IValidator setupValidator(NumberFormat var1);

    protected abstract String getInvalidString();

    protected abstract Number getOutOfRangeNumber();

    protected abstract Number getInRangeNumber();

    public void testInvalidValueReturnsError() throws Exception {
        IStatus status = this.validator.validate((Object)this.getInvalidString());
        StringToNumberValidatorTestHarness.assertEquals((String)"error severify", (int)4, (int)status.getSeverity());
        StringToNumberValidatorTestHarness.assertNotNull((String)"message not null", (Object)status.getMessage());
    }

    public void testOutOfRangeValueReturnsError() throws Exception {
        String string = this.numberFormat.format((Object)this.getOutOfRangeNumber());
        IStatus status = this.validator.validate((Object)string);
        StringToNumberValidatorTestHarness.assertEquals((int)4, (int)status.getSeverity());
        StringToNumberValidatorTestHarness.assertNotNull((Object)status.getMessage());
    }

    public void testValidateValidValue() throws Exception {
        String string = this.numberFormat.format((Object)this.getInRangeNumber());
        StringToNumberValidatorTestHarness.assertTrue((boolean)this.validator.validate((Object)string).isOK());
    }
}

