/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.tests.databinding.BindingTestSuite;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ComboUpdatingTest
extends ScenariosTestCase {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private Combo comboEditable;
    private static final String PROP_TEXT = "text";
    private String text = "Hello, world";
    private static final String PROP_CHOICES = "choices";
    private List choices = new ArrayList();
    private static final String NEXT = "Next";
    static /* synthetic */ Class class$0;

    public ComboUpdatingTest() {
        this.choices.add("Banana");
        this.choices.add("Apple");
        this.choices.add("Mango");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List getChoices() {
        return this.choices;
    }

    public void setChoices(List choices) {
        this.choices = choices;
        this.firePropertyChange(PROP_CHOICES, null, null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getComposite().setLayout((Layout)new FillLayout());
        this.comboEditable = new Combo(this.getComposite(), 4);
    }

    public void testBindText() throws Exception {
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.comboEditable), BeansObservables.observeValue((Object)((Object)this), (String)PROP_TEXT));
        this.spinEventLoop(0);
        ComboUpdatingTest.assertEquals((String)"Should find value of text", (String)this.text, (String)this.comboEditable.getText());
        this.comboEditable.setText(NEXT);
        this.spinEventLoop(0);
        ComboUpdatingTest.assertEquals((String)"Should find new value in text", (String)NEXT, (String)this.text);
    }

    public void testBindItems_listHasSameItems_editable() throws Exception {
        if (BindingTestSuite.failingTestsDisabled(this)) {
            return;
        }
        this.text = "Apple";
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.comboEditable), BeansObservables.observeValue((Object)((Object)this), (String)PROP_TEXT));
        this.spinEventLoop(0);
        ComboUpdatingTest.assertEquals((String)"Should find value of text", (String)this.text, (String)this.comboEditable.getText());
        WritableList list = new WritableList(this.getChoices(), null);
        this.getDbc().bindList(SWTObservables.observeItems((Control)this.comboEditable), (IObservableList)list);
        this.spinEventLoop(0);
        int position = 0;
        Iterator choicesIter = this.choices.iterator();
        while (choicesIter.hasNext()) {
            String element = (String)choicesIter.next();
            ComboUpdatingTest.assertEquals((String)element, (String)this.comboEditable.getItem(position));
            ++position;
        }
        ComboUpdatingTest.assertEquals((String)"Should find value of combo.getText()", (String)"", (String)this.comboEditable.getText());
        this.comboEditable.setText("Banana");
        this.spinEventLoop(0);
        ComboUpdatingTest.assertEquals((String)"Should find value of text", (String)"Banana", (String)this.text);
    }

    public void testBindItems_listHasDifferentItems_editable() throws Exception {
        if (BindingTestSuite.failingTestsDisabled(this)) {
            return;
        }
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.comboEditable), BeansObservables.observeValue((Object)((Object)this), (String)PROP_TEXT));
        this.spinEventLoop(0);
        ComboUpdatingTest.assertEquals((String)"Should find value of text", (String)this.text, (String)this.comboEditable.getText());
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableList list = new WritableList(arrayList, (Object)clazz);
        list.addAll((Collection)this.getChoices());
        this.getDbc().bindList(SWTObservables.observeItems((Control)this.comboEditable), (IObservableList)list);
        this.spinEventLoop(0);
        int position = 0;
        Iterator choicesIter = this.choices.iterator();
        while (choicesIter.hasNext()) {
            String element = (String)choicesIter.next();
            ComboUpdatingTest.assertEquals((String)element, (String)this.comboEditable.getItem(position));
            ++position;
        }
        ComboUpdatingTest.assertEquals((String)"Should find value of combo.getText()", (String)"", (String)this.comboEditable.getText());
        this.comboEditable.setText("Banana");
        this.spinEventLoop(0);
        ComboUpdatingTest.assertEquals((String)"Should find value of text", (String)"Banana", (String)this.text);
    }
}

