/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.examples.databinding.model.Catalog;
import org.eclipse.jface.examples.databinding.model.Lodging;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class MasterDetailScenarios
extends ScenariosTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected Object getViewerSelection(ContentViewer contentViewer) {
        return ((IStructuredSelection)contentViewer.getSelection()).getFirstElement();
    }

    protected List getViewerContent(ContentViewer contentViewer) {
        Object[] elements = ((IStructuredContentProvider)contentViewer.getContentProvider()).getElements(null);
        if (elements != null) {
            return Arrays.asList(elements);
        }
        return null;
    }

    public void testScenario01() {
        ListViewer listViewer = new ListViewer(this.getComposite(), 2048);
        Realm realm = SWTObservables.getRealm((Display)listViewer.getControl().getDisplay());
        listViewer.getList().setLayoutData((Object)new GridData(4, 4, false, false));
        Catalog catalog = SampleData.CATALOG_2005;
        IObservableList lodgings = BeansObservables.observeList((Realm)realm, (Object)catalog, (String)"lodgings");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.examples.databinding.model.Lodging");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ViewerSupport.bind((StructuredViewer)listViewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value((Class)clazz, (String)"name"));
        this.assertArrayEquals(catalog.getLodgings(), this.getViewerContent((ContentViewer)listViewer).toArray());
        IViewerObservableValue selectedLodging = ViewersObservables.observeSingleSelection((Viewer)listViewer);
        selectedLodging.setValue((Object)SampleData.CAMP_GROUND);
        MasterDetailScenarios.assertEquals((Object)SampleData.CAMP_GROUND, (Object)this.getViewerSelection((ContentViewer)listViewer));
        Text txtName = new Text(this.getComposite(), 2048);
        DataBindingContext dataBindingContext = this.getDbc();
        ISWTObservableValue iSWTObservableValue = SWTObservables.observeText((Control)txtName, (int)24);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        dataBindingContext.bindValue((IObservableValue)iSWTObservableValue, BeansObservables.observeDetailValue((IObservableValue)selectedLodging, (String)"name", (Class)clazz2));
        MasterDetailScenarios.assertEquals((String)txtName.getText(), (String)SampleData.CAMP_GROUND.getName());
        this.enterText(txtName, "foobar");
        MasterDetailScenarios.assertEquals((String)"foobar", (String)SampleData.CAMP_GROUND.getName());
        listViewer.setSelection((ISelection)new StructuredSelection((Object)SampleData.FIVE_STAR_HOTEL));
        MasterDetailScenarios.assertEquals((Object)SampleData.FIVE_STAR_HOTEL, (Object)selectedLodging.getValue());
        MasterDetailScenarios.assertEquals((String)SampleData.FIVE_STAR_HOTEL.getName(), (String)txtName.getText());
        SampleData.FIVE_STAR_HOTEL.setName("barfoo");
        MasterDetailScenarios.assertEquals((String)"barfoo", (String)txtName.getText());
        selectedLodging.dispose();
    }

    public void testScenario02() {
        ListViewer listViewer = new ListViewer(this.getComposite(), 2048);
        listViewer.getList().setLayoutData((Object)new GridData(4, 4, false, false));
        Catalog catalog = SampleData.CATALOG_2005;
        IObservableList lodgings = BeansObservables.observeList((Realm)this.realm, (Object)catalog, (String)"lodgings");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.examples.databinding.model.Lodging");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ViewerSupport.bind((StructuredViewer)listViewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value((Class)clazz, (String)"name"));
        this.assertArrayEquals(catalog.getLodgings(), this.getViewerContent((ContentViewer)listViewer).toArray());
        IViewerObservableValue selectedLodgingObservable = ViewersObservables.observeSingleSelection((Viewer)listViewer);
        selectedLodgingObservable.setValue(null);
        MasterDetailScenarios.assertTrue((boolean)listViewer.getSelection().isEmpty());
        ComputedValue selectionExistsObservable = new ComputedValue(Boolean.TYPE, (IObservableValue)selectedLodgingObservable){
            private final /* synthetic */ IObservableValue val$selectedLodgingObservable;
            {
                this.val$selectedLodgingObservable = iObservableValue;
            }

            protected Object calculate() {
                return new Boolean(this.val$selectedLodgingObservable.getValue() != null);
            }
        };
        MasterDetailScenarios.assertFalse((boolean)((Boolean)selectionExistsObservable.getValue()));
        Text txtName = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)txtName), (IObservableValue)selectionExistsObservable);
        DataBindingContext dataBindingContext = this.getDbc();
        ISWTObservableValue iSWTObservableValue = SWTObservables.observeText((Control)txtName, (int)24);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        dataBindingContext.bindValue((IObservableValue)iSWTObservableValue, BeansObservables.observeDetailValue((IObservableValue)selectedLodgingObservable, (String)"name", (Class)clazz2));
        MasterDetailScenarios.assertEquals((String)txtName.getText(), (String)"");
        MasterDetailScenarios.assertFalse((boolean)txtName.getEnabled());
        Text txtDescription = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)txtDescription), (IObservableValue)selectionExistsObservable);
        DataBindingContext dataBindingContext2 = this.getDbc();
        ISWTObservableValue iSWTObservableValue2 = SWTObservables.observeText((Control)txtDescription, (int)24);
        IObservableFactory iObservableFactory = BeansObservables.valueFactory((Realm)this.realm, (String)"description");
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        dataBindingContext2.bindValue((IObservableValue)iSWTObservableValue2, MasterDetailObservables.detailValue((IObservableValue)selectedLodgingObservable, (IObservableFactory)iObservableFactory, (Object)clazz3));
        MasterDetailScenarios.assertEquals((String)txtDescription.getText(), (String)"");
        MasterDetailScenarios.assertFalse((boolean)txtDescription.getEnabled());
        Button addButton = new Button(this.getComposite(), 8);
        addButton.addSelectionListener(new SelectionListener((IObservableValue)selectedLodgingObservable, catalog, listViewer, txtName, txtDescription){
            private final /* synthetic */ IObservableValue val$selectedLodgingObservable;
            private final /* synthetic */ Catalog val$catalog;
            private final /* synthetic */ ListViewer val$listViewer;
            private final /* synthetic */ Text val$txtName;
            private final /* synthetic */ Text val$txtDescription;
            {
                this.val$selectedLodgingObservable = iObservableValue;
                this.val$catalog = catalog;
                this.val$listViewer = listViewer;
                this.val$txtName = text;
                this.val$txtDescription = text2;
            }

            public void widgetSelected(SelectionEvent e) {
                Lodging selectedLodging = (Lodging)this.val$selectedLodgingObservable.getValue();
                int insertionIndex = 0;
                if (selectedLodging != null) {
                    insertionIndex = Arrays.asList(this.val$catalog.getLodgings()).indexOf(selectedLodging);
                    MasterDetailScenarios.assertTrue((insertionIndex >= 0 ? 1 : 0) != 0);
                }
                Lodging newLodging = SampleData.FACTORY.createLodging();
                int itemCount = this.val$listViewer.getList().getItemCount();
                newLodging.setName("new lodging name " + itemCount);
                newLodging.setDescription("new lodging description " + itemCount);
                this.val$catalog.addLodging(newLodging);
                MasterDetailScenarios.assertEquals((int)(itemCount + 1), (int)this.val$listViewer.getList().getItemCount());
                this.val$listViewer.setSelection((ISelection)new StructuredSelection((Object)newLodging));
                MasterDetailScenarios.assertSame((Object)newLodging, (Object)this.val$selectedLodgingObservable.getValue());
                MasterDetailScenarios.assertTrue((boolean)this.val$txtName.getEnabled());
                MasterDetailScenarios.assertTrue((boolean)this.val$txtDescription.getEnabled());
                MasterDetailScenarios.assertEquals((String)newLodging.getName(), (String)this.val$txtName.getText());
                MasterDetailScenarios.assertEquals((String)newLodging.getDescription(), (String)this.val$txtDescription.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button removeButton = new Button(this.getComposite(), 8);
        removeButton.addSelectionListener(new SelectionListener((IObservableValue)selectedLodgingObservable, catalog, listViewer){
            private final /* synthetic */ IObservableValue val$selectedLodgingObservable;
            private final /* synthetic */ Catalog val$catalog;
            private final /* synthetic */ ListViewer val$listViewer;
            {
                this.val$selectedLodgingObservable = iObservableValue;
                this.val$catalog = catalog;
                this.val$listViewer = listViewer;
            }

            public void widgetSelected(SelectionEvent e) {
                Lodging selectedLodging = (Lodging)this.val$selectedLodgingObservable.getValue();
                MasterDetailScenarios.assertNotNull((Object)selectedLodging);
                int deletionIndex = Arrays.asList(this.val$catalog.getLodgings()).indexOf(selectedLodging);
                MasterDetailScenarios.assertTrue((deletionIndex >= 0 ? 1 : 0) != 0);
                int itemCount = this.val$listViewer.getList().getItemCount();
                this.val$catalog.removeLodging(selectedLodging);
                MasterDetailScenarios.assertEquals((int)(itemCount - 1), (int)this.val$listViewer.getList().getItemCount());
                MasterDetailScenarios.assertNull((Object)this.val$selectedLodgingObservable.getValue());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.pushButtonWithEvents(addButton);
        this.pushButtonWithEvents(removeButton);
        this.pushButtonWithEvents(addButton);
        this.pushButtonWithEvents(addButton);
        this.pushButtonWithEvents(removeButton);
    }

    public void testScenario03() {
        Catalog catalog = SampleData.CATALOG_2005;
        ListViewer categoryListViewer = new ListViewer(this.getComposite(), 2048);
        categoryListViewer.getList().setLayoutData((Object)new GridData(4, 4, false, false));
        IObservableList categories = BeansObservables.observeList((Realm)this.realm, (Object)catalog, (String)"categories");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jface.examples.databinding.model.Category");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ViewerSupport.bind((StructuredViewer)categoryListViewer, (IObservableList)categories, (IValueProperty)BeanProperties.value((Class)clazz, (String)"name"));
        this.assertArrayEquals(catalog.getCategories(), this.getViewerContent((ContentViewer)categoryListViewer).toArray());
        IViewerObservableValue selectedCategoryObservable = ViewersObservables.observeSingleSelection((Viewer)categoryListViewer);
        ListViewer adventureListViewer = new ListViewer(this.getComposite(), 2048);
        adventureListViewer.getList().setLayoutData((Object)new GridData(4, 4, false, false));
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.jface.examples.databinding.model.Adventure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableList adventures = BeansObservables.observeDetailList((IObservableValue)selectedCategoryObservable, (String)"adventures", (Class)clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.jface.examples.databinding.model.Adventure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ViewerSupport.bind((StructuredViewer)adventureListViewer, (IObservableList)adventures, (IValueProperty)BeanProperties.value((Class)clazz3, (String)"name"));
        ComputedValue categorySelectionExistsObservable = new ComputedValue((IObservableValue)selectedCategoryObservable){
            private final /* synthetic */ IObservableValue val$selectedCategoryObservable;
            {
                this.val$selectedCategoryObservable = iObservableValue;
            }

            protected Object calculate() {
                return new Boolean(this.val$selectedCategoryObservable.getValue() != null);
            }
        };
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)adventureListViewer.getList()), (IObservableValue)categorySelectionExistsObservable);
        IViewerObservableValue selectedAdventureObservable = ViewersObservables.observeSingleSelection((Viewer)adventureListViewer);
        ComputedValue adventureSelectionExistsObservable = new ComputedValue((IObservableValue)selectedAdventureObservable){
            private final /* synthetic */ IObservableValue val$selectedAdventureObservable;
            {
                this.val$selectedAdventureObservable = iObservableValue;
            }

            protected Object calculate() {
                return new Boolean(this.val$selectedAdventureObservable.getValue() != null);
            }
        };
        Text txtName = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)txtName), (IObservableValue)adventureSelectionExistsObservable);
        DataBindingContext dataBindingContext = this.getDbc();
        ISWTObservableValue iSWTObservableValue = SWTObservables.observeText((Control)txtName, (int)24);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        dataBindingContext.bindValue((IObservableValue)iSWTObservableValue, BeansObservables.observeDetailValue((IObservableValue)selectedAdventureObservable, (String)"name", (Class)clazz4));
        MasterDetailScenarios.assertEquals((String)txtName.getText(), (String)"");
        MasterDetailScenarios.assertFalse((boolean)txtName.getEnabled());
        Text txtDescription = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)txtDescription), (IObservableValue)adventureSelectionExistsObservable);
        DataBindingContext dataBindingContext2 = this.getDbc();
        ISWTObservableValue iSWTObservableValue2 = SWTObservables.observeText((Control)txtDescription, (int)24);
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        dataBindingContext2.bindValue((IObservableValue)iSWTObservableValue2, BeansObservables.observeDetailValue((IObservableValue)selectedAdventureObservable, (String)"description", (Class)clazz5));
        MasterDetailScenarios.assertFalse((boolean)adventureListViewer.getList().isEnabled());
        categoryListViewer.setSelection((ISelection)new StructuredSelection((Object)SampleData.SUMMER_CATEGORY));
        MasterDetailScenarios.assertTrue((boolean)adventureListViewer.getList().isEnabled());
        MasterDetailScenarios.assertFalse((boolean)txtName.getEnabled());
        adventureListViewer.setSelection((ISelection)new StructuredSelection((Object)SampleData.RAFTING_HOLIDAY));
        MasterDetailScenarios.assertEquals((Object)Boolean.TRUE, (Object)adventureSelectionExistsObservable.getValue());
        MasterDetailScenarios.assertTrue((boolean)txtName.getEnabled());
        MasterDetailScenarios.assertEquals((String)SampleData.RAFTING_HOLIDAY.getName(), (String)txtName.getText());
        categoryListViewer.setSelection((ISelection)new StructuredSelection((Object)SampleData.WINTER_CATEGORY));
        MasterDetailScenarios.assertTrue((boolean)adventureListViewer.getList().isEnabled());
        MasterDetailScenarios.assertFalse((boolean)txtName.getEnabled());
    }
}

