/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class WidgetPropertiesTest
extends AbstractSWTTestCase {
    private Shell shell;
    private String string1;
    private String string2;
    private Image image1;
    private Image image2;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = this.getShell();
        this.string1 = "1";
        this.string2 = "2";
        this.image1 = this.shell.getDisplay().getSystemImage(8);
        this.image2 = this.shell.getDisplay().getSystemImage(1);
        RealmTester.setDefault((Realm)SWTObservables.getRealm((Display)this.shell.getDisplay()));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        RealmTester.setDefault(null);
    }

    protected Shell getShell() {
        if (this.shell == null) {
            this.shell = new Shell(512);
        }
        return this.shell;
    }

    public void testImage_ObserveButton() {
        Button button = new Button((Composite)this.shell, 8);
        button.setImage(this.image1);
        ISWTObservableValue observable = WidgetProperties.image().observe((Widget)button);
        WidgetPropertiesTest.assertSame((Object)this.image1, (Object)observable.getValue());
        observable.setValue((Object)this.image2);
        WidgetPropertiesTest.assertSame((Object)this.image2, (Object)button.getImage());
    }

    public void testImage_ObserveCLabel() {
        CLabel label = new CLabel((Composite)this.shell, 0);
        label.setImage(this.image1);
        ISWTObservableValue observable = WidgetProperties.image().observe((Widget)label);
        WidgetPropertiesTest.assertSame((Object)this.image1, (Object)observable.getValue());
        observable.setValue((Object)this.image2);
        WidgetPropertiesTest.assertSame((Object)this.image2, (Object)label.getImage());
    }

    public void testImage_ObserveLabel() {
        Label label = new Label((Composite)this.shell, 0);
        label.setImage(this.image1);
        ISWTObservableValue observable = WidgetProperties.image().observe((Widget)label);
        WidgetPropertiesTest.assertSame((Object)this.image1, (Object)observable.getValue());
        observable.setValue((Object)this.image2);
        WidgetPropertiesTest.assertSame((Object)this.image2, (Object)label.getImage());
    }

    public void testText_ObserveButton() {
        Button button = new Button((Composite)this.shell, 8);
        button.setText(this.string1);
        ISWTObservableValue observable = WidgetProperties.text().observe((Widget)button);
        WidgetPropertiesTest.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        WidgetPropertiesTest.assertEquals((String)this.string2, (String)button.getText());
    }

    public void testTooltipText_ObserveCTabItem() {
        CTabFolder tf = new CTabFolder((Composite)this.shell, 0);
        CTabItem item = new CTabItem(tf, 0);
        item.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)item);
        WidgetPropertiesTest.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        WidgetPropertiesTest.assertEquals((String)this.string2, (String)item.getToolTipText());
    }

    public void testTooltipText_ObserveControl() {
        Label control = new Label((Composite)this.shell, 0);
        control.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)control);
        WidgetPropertiesTest.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        WidgetPropertiesTest.assertEquals((String)this.string2, (String)control.getToolTipText());
    }

    public void testTooltipText_ObserveTabItem() {
        TabFolder tf = new TabFolder((Composite)this.shell, 0);
        TabItem item = new TabItem(tf, 0);
        item.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)item);
        WidgetPropertiesTest.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        WidgetPropertiesTest.assertEquals((String)this.string2, (String)item.getToolTipText());
    }

    public void testTooltipText_ObserveTableColumn() {
        Table table = new Table((Composite)this.shell, 0);
        TableColumn column = new TableColumn(table, 0);
        column.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)column);
        WidgetPropertiesTest.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        WidgetPropertiesTest.assertEquals((String)this.string2, (String)column.getToolTipText());
    }

    public void testTooltipText_ObserveToolItem() {
        ToolBar bar = new ToolBar((Composite)this.shell, 0);
        ToolItem item = new ToolItem(bar, 0);
        item.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)item);
        WidgetPropertiesTest.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        WidgetPropertiesTest.assertEquals((String)this.string2, (String)item.getToolTipText());
    }

    public void testTooltipText_ObserveTrayItem() {
        Tray tray = this.shell.getDisplay().getSystemTray();
        TrayItem item = new TrayItem(tray, 0);
        try {
            item.setToolTipText(this.string1);
            ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)item);
            WidgetPropertiesTest.assertEquals((Object)this.string1, (Object)observable.getValue());
            observable.setValue((Object)this.string2);
            WidgetPropertiesTest.assertEquals((String)this.string2, (String)item.getToolTipText());
        }
        finally {
            item.dispose();
        }
    }

    public void testTooltipText_ObserveTreeColumn() {
        Tree tree = new Tree((Composite)this.shell, 0);
        TreeColumn column = new TreeColumn(tree, 0);
        column.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)column);
        WidgetPropertiesTest.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        WidgetPropertiesTest.assertEquals((String)this.string2, (String)column.getToolTipText());
    }

    public void testEnabled_ObserveMenu() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        ISWTObservableValue observable = WidgetProperties.enabled().observe((Widget)menu);
        WidgetPropertiesTest.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        menu.setEnabled(true);
        WidgetPropertiesTest.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        WidgetPropertiesTest.assertEquals((boolean)false, (boolean)menu.getEnabled());
    }

    public void testEnabled_ObserveMenuItem() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        MenuItem item = new MenuItem(menu, 8);
        ISWTObservableValue observable = WidgetProperties.enabled().observe((Widget)item);
        WidgetPropertiesTest.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        item.setEnabled(true);
        WidgetPropertiesTest.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        WidgetPropertiesTest.assertEquals((boolean)false, (boolean)item.getEnabled());
    }

    public void testSelection_ObserveMenuItem() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        MenuItem item = new MenuItem(menu, 32);
        ISWTObservableValue observable = WidgetProperties.selection().observe((Widget)item);
        WidgetPropertiesTest.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        item.setSelection(true);
        WidgetPropertiesTest.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        WidgetPropertiesTest.assertEquals((boolean)false, (boolean)item.getSelection());
    }

    public void testEnabled_ObserveScrollBar() {
        ScrollBar bar = this.shell.getVerticalBar();
        ISWTObservableValue observable = WidgetProperties.enabled().observe((Widget)bar);
        WidgetPropertiesTest.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        bar.setEnabled(true);
        WidgetPropertiesTest.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        WidgetPropertiesTest.assertEquals((boolean)false, (boolean)bar.getEnabled());
    }

    public void testEnabled_ObserveToolItem() {
        ToolBar bar = new ToolBar((Composite)this.shell, 256);
        ToolItem item = new ToolItem(bar, 8);
        ISWTObservableValue observable = WidgetProperties.enabled().observe((Widget)item);
        WidgetPropertiesTest.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        item.setEnabled(true);
        WidgetPropertiesTest.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        WidgetPropertiesTest.assertEquals((boolean)false, (boolean)item.getEnabled());
    }

    public void testEditable_ObserveText() {
        Text text = new Text((Composite)this.shell, 0);
        ISWTObservableValue observable = WidgetProperties.editable().observe((Widget)text);
        WidgetPropertiesTest.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        text.setEditable(false);
        WidgetPropertiesTest.assertEquals((Object)Boolean.FALSE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.TRUE);
        WidgetPropertiesTest.assertEquals((boolean)true, (boolean)text.getEditable());
    }

    public void testEditable_ObserveCCombo() {
        CCombo combo = new CCombo((Composite)this.shell, 0);
        ISWTObservableValue observable = WidgetProperties.editable().observe((Widget)combo);
        WidgetPropertiesTest.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        combo.setEditable(false);
        WidgetPropertiesTest.assertEquals((Object)Boolean.FALSE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.TRUE);
        WidgetPropertiesTest.assertEquals((boolean)true, (boolean)combo.getEditable());
    }

    public void testEditable_ObserveStyledText() {
        StyledText styledText = new StyledText((Composite)this.shell, 0);
        ISWTObservableValue observable = WidgetProperties.editable().observe((Widget)styledText);
        WidgetPropertiesTest.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        styledText.setEditable(false);
        WidgetPropertiesTest.assertEquals((Object)Boolean.FALSE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.TRUE);
        WidgetPropertiesTest.assertEquals((boolean)true, (boolean)styledText.getEditable());
    }
}

