/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ObservableListContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TableViewer viewer;
    private ObservableListContentProvider contentProvider;
    private IObservableList input;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.viewer = new TableViewer((Composite)this.shell, 0);
        this.contentProvider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.input = new WritableList();
        this.viewer.setInput((Object)this.input);
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.viewer = null;
        this.input = null;
        super.tearDown();
    }

    public void testKnownElements_Realm() throws Exception {
        ObservableListContentProviderTest.assertSame((String)"realm for the known elements should be the SWT realm", (Object)SWTObservables.getRealm((Display)Display.getDefault()), (Object)this.contentProvider.getKnownElements().getRealm());
    }

    public void testRealizedElements_Realm() {
        ObservableListContentProviderTest.assertSame((String)"realm for the realized elements should be the SWT realm", (Object)SWTObservables.getRealm((Display)Display.getDefault()), (Object)this.contentProvider.getRealizedElements().getRealm());
    }

    public void testKnownElementsAfterSetInput() {
        ObservableListContentProviderTest.assertEquals((int)0, (int)this.contentProvider.getKnownElements().size());
        HashSet<String> newElements = new HashSet<String>(Arrays.asList("one", "two", "three"));
        WritableList newInput = new WritableList();
        newInput.addAll(newElements);
        this.viewer.setInput((Object)newInput);
        ObservableListContentProviderTest.assertEquals(newElements, (Object)this.contentProvider.getKnownElements());
    }

    public void testViewerUpdate_RemoveElementAfterMutation() {
        Mutable element = new Mutable(1);
        this.input.add((Object)element);
        ObservableListContentProviderTest.assertEquals((int)1, (int)this.viewer.getTable().getItemCount());
        ++element.id;
        this.input.clear();
        ObservableListContentProviderTest.assertEquals((int)0, (int)this.viewer.getTable().getItemCount());
    }

    public void testInputChanged_ClearsKnownElements() {
        Object element = new Object();
        this.input.add(element);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        ObservableListContentProviderTest.assertEquals(Collections.singleton(element), (Object)knownElements);
        this.viewer.setInput((Object)Observables.emptyObservableList());
        ObservableListContentProviderTest.assertEquals((Object)Collections.EMPTY_SET, (Object)knownElements);
    }

    public void testInputChanged_ClearsRealizedElements() {
        IObservableSet realizedElements = this.contentProvider.getRealizedElements();
        Object element = new Object();
        this.input.add(element);
        ObservableListContentProviderTest.assertEquals(Collections.singleton(element), (Object)realizedElements);
        this.viewer.setInput((Object)Observables.emptyObservableList());
        ObservableListContentProviderTest.assertEquals((Object)Collections.EMPTY_SET, (Object)realizedElements);
    }

    static class Mutable {
        public int id;

        public Mutable(int id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mutable that = (Mutable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

