/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ObservableSetContentProviderTest
extends AbstractSWTTestCase {
    private Shell shell;
    private TableViewer viewer;
    private ObservableSetContentProvider contentProvider;
    private IObservableSet input;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.viewer = new TableViewer((Composite)this.shell, 0);
        this.contentProvider = new ObservableSetContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.input = new WritableSet();
        this.viewer.setInput((Object)this.input);
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.viewer = null;
        this.input = null;
        super.tearDown();
    }

    public void testKnownElements_Realm() throws Exception {
        ObservableSetContentProviderTest.assertSame((String)"realm for the known elements should be the SWT realm", (Object)SWTObservables.getRealm((Display)Display.getDefault()), (Object)this.contentProvider.getKnownElements().getRealm());
    }

    public void testRealizedElements_Realm() {
        ObservableSetContentProviderTest.assertSame((String)"realm for the realized elements should be the SWT realm", (Object)SWTObservables.getRealm((Display)Display.getDefault()), (Object)this.contentProvider.getRealizedElements().getRealm());
    }

    public void testKnownElementsAfterSetInput() {
        ObservableSetContentProviderTest.assertEquals((int)0, (int)this.contentProvider.getKnownElements().size());
        HashSet<String> newElements = new HashSet<String>(Arrays.asList("one", "two", "three"));
        WritableSet newInput = new WritableSet();
        newInput.addAll(newElements);
        this.viewer.setInput((Object)newInput);
        ObservableSetContentProviderTest.assertEquals(newElements, (Object)this.contentProvider.getKnownElements());
    }

    public void testViewerUpdate_RemoveElementAfterMutation() {
        Mutable element = new Mutable(1);
        this.input.add((Object)element);
        ObservableSetContentProviderTest.assertEquals((int)1, (int)this.viewer.getTable().getItemCount());
        ++element.id;
        this.input.clear();
        ObservableSetContentProviderTest.assertEquals((int)0, (int)this.viewer.getTable().getItemCount());
    }

    public void testInputChanged_ClearsKnownElements() {
        Object element = new Object();
        this.input.add(element);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        ObservableSetContentProviderTest.assertEquals(Collections.singleton(element), (Object)knownElements);
        this.viewer.setInput((Object)Observables.emptyObservableSet());
        ObservableSetContentProviderTest.assertEquals((Object)Collections.EMPTY_SET, (Object)knownElements);
    }

    public void testInputChanged_ClearsRealizedElements() {
        IObservableSet realizedElements = this.contentProvider.getRealizedElements();
        Object element = new Object();
        this.input.add(element);
        ObservableSetContentProviderTest.assertEquals(Collections.singleton(element), (Object)realizedElements);
        this.viewer.setInput((Object)Observables.emptyObservableSet());
        ObservableSetContentProviderTest.assertEquals((Object)Collections.EMPTY_SET, (Object)realizedElements);
    }

    static class Mutable {
        public int id;

        public Mutable(int id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mutable that = (Mutable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

