/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ControlObservableValueTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
            this.shell = null;
        }
    }

    public void testSetValueEnabled() throws Exception {
        ISWTObservableValue observableValue = SWTObservables.observeEnabled((Control)this.shell);
        Boolean value = Boolean.FALSE;
        observableValue.setValue((Object)value);
        ControlObservableValueTest.assertFalse((boolean)this.shell.isEnabled());
    }

    public void testGetValueEnabled() throws Exception {
        ISWTObservableValue value = SWTObservables.observeEnabled((Control)this.shell);
        this.shell.setEnabled(false);
        ControlObservableValueTest.assertEquals((Object)Boolean.FALSE, (Object)value.getValue());
    }

    public void testGetValueTypeEnabled() throws Exception {
        ISWTObservableValue value = SWTObservables.observeEnabled((Control)this.shell);
        ControlObservableValueTest.assertEquals(Boolean.TYPE, (Object)value.getValueType());
    }

    public void testSetValueVisible() throws Exception {
        ISWTObservableValue value = SWTObservables.observeVisible((Control)this.shell);
        value.setValue((Object)Boolean.FALSE);
        ControlObservableValueTest.assertFalse((boolean)this.shell.isVisible());
    }

    public void testGetValueVisible() throws Exception {
        ISWTObservableValue value = SWTObservables.observeVisible((Control)this.shell);
        this.shell.setVisible(false);
        ControlObservableValueTest.assertEquals((Object)Boolean.FALSE, (Object)value.getValue());
    }

    public void testGetValueTypeVisible() throws Exception {
        ISWTObservableValue value = SWTObservables.observeVisible((Control)this.shell);
        ControlObservableValueTest.assertEquals(Boolean.TYPE, (Object)value.getValueType());
    }

    public void testSetValueForeground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeForeground((Control)this.shell);
        Color color = this.shell.getDisplay().getSystemColor(2);
        value.setValue((Object)color);
        ControlObservableValueTest.assertEquals((Object)color, (Object)this.shell.getForeground());
    }

    public void testGetValueForeground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeForeground((Control)this.shell);
        Color color = this.shell.getDisplay().getSystemColor(2);
        this.shell.setForeground(color);
        ControlObservableValueTest.assertEquals((Object)color, (Object)value.getValue());
    }

    public void testGetValueTypeForgroundColor() throws Exception {
        ISWTObservableValue value = SWTObservables.observeForeground((Control)this.shell);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ControlObservableValueTest.assertEquals((Object)clazz, (Object)value.getValueType());
    }

    public void testGetValueBackground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeBackground((Control)this.shell);
        Color color = this.shell.getDisplay().getSystemColor(2);
        this.shell.setBackground(color);
        ControlObservableValueTest.assertEquals((Object)color, (Object)value.getValue());
    }

    public void testSetValueBackground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeBackground((Control)this.shell);
        Color color = this.shell.getDisplay().getSystemColor(2);
        value.setValue((Object)color);
        ControlObservableValueTest.assertEquals((Object)color, (Object)this.shell.getBackground());
    }

    public void testGetValueTypeBackgroundColor() throws Exception {
        ISWTObservableValue value = SWTObservables.observeBackground((Control)this.shell);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ControlObservableValueTest.assertEquals((Object)clazz, (Object)value.getValueType());
    }

    public void testGetValueTypeTooltip() throws Exception {
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)this.shell);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ControlObservableValueTest.assertEquals((Object)clazz, (Object)value.getValueType());
    }

    public void testSetValueFont() throws Exception {
        ISWTObservableValue value = SWTObservables.observeFont((Control)this.shell);
        Font font = JFaceResources.getDialogFont();
        value.setValue((Object)font);
        ControlObservableValueTest.assertEquals((Object)font, (Object)this.shell.getFont());
    }

    public void testGetValueFont() throws Exception {
        ISWTObservableValue value = SWTObservables.observeFont((Control)this.shell);
        Font font = JFaceResources.getDialogFont();
        this.shell.setFont(font);
        ControlObservableValueTest.assertEquals((Object)font, (Object)value.getValue());
    }

    public void testGetValueTypeFont() throws Exception {
        ISWTObservableValue value = SWTObservables.observeFont((Control)this.shell);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.graphics.Font");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ControlObservableValueTest.assertEquals((Object)clazz, (Object)value.getValueType());
    }

    public void testSetValueTooltipText() throws Exception {
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)this.shell);
        String text = "text";
        value.setValue((Object)text);
        ControlObservableValueTest.assertEquals((String)text, (String)this.shell.getToolTipText());
    }

    public void testGetValueTooltipText() throws Exception {
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)this.shell);
        String text = "text";
        this.shell.setToolTipText(text);
        ControlObservableValueTest.assertEquals((Object)text, (Object)value.getValue());
    }

    public void testGetValueTypeTooltipText() throws Exception {
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)this.shell);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ControlObservableValueTest.assertEquals((Object)clazz, (Object)value.getValueType());
    }

    public void testObserveFocus() {
        this.shell.setLayout((Layout)new FillLayout());
        Text c1 = new Text((Composite)this.shell, 0);
        Text c2 = new Text((Composite)this.shell, 0);
        this.shell.pack();
        this.shell.setVisible(true);
        ControlObservableValueTest.assertTrue((boolean)c1.setFocus());
        ISWTObservableValue value = WidgetProperties.focused().observe((Widget)c2);
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)value);
        ControlObservableValueTest.assertTrue((boolean)c2.setFocus());
        this.processDisplayQueue();
        ControlObservableValueTest.assertEquals((Object)Boolean.TRUE, (Object)value.getValue());
        ControlObservableValueTest.assertEquals((int)1, (int)tracker.count);
        ControlObservableValueTest.assertEquals((Object)Boolean.FALSE, (Object)tracker.event.diff.getOldValue());
        ControlObservableValueTest.assertEquals((Object)Boolean.TRUE, (Object)tracker.event.diff.getNewValue());
    }

    private void processDisplayQueue() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }
}

