/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.internal.databinding.swt.SWTObservableValueDecorator;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SWTDelayedObservableValueDecoratorTest
extends AbstractDefaultRealmTestCase {
    private Display display;
    private Shell shell;
    private Object oldValue;
    private Object newValue;
    private ISWTObservableValue target;
    private ISWTObservableValue delayed;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        this.target = new SWTObservableValueDecorator((IObservableValue)new WritableValue(SWTObservables.getRealm((Display)this.display)), (Widget)this.shell);
        this.oldValue = new Object();
        this.newValue = new Object();
        this.target.setValue(this.oldValue);
        this.delayed = SWTObservables.observeDelayedValue((int)1, (ISWTObservableValue)this.target);
    }

    protected void tearDown() throws Exception {
        this.delayed.dispose();
        this.target.dispose();
        this.target = null;
        this.shell.dispose();
        this.shell = null;
        this.display = null;
        super.tearDown();
    }

    public void testFocusOut_FiresPendingValueChange() {
        this.assertFiresPendingValueChange(new Runnable(){

            public void run() {
                SWTDelayedObservableValueDecoratorTest.this.shell.notifyListeners(16, new Event());
            }
        });
    }

    private void assertFiresPendingValueChange(Runnable runnable) {
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)this.delayed);
        this.target.setValue(this.newValue);
        SWTDelayedObservableValueDecoratorTest.assertTrue((boolean)this.delayed.isStale());
        SWTDelayedObservableValueDecoratorTest.assertEquals((int)0, (int)tracker.count);
        runnable.run();
        SWTDelayedObservableValueDecoratorTest.assertFalse((boolean)this.delayed.isStale());
        SWTDelayedObservableValueDecoratorTest.assertEquals((int)1, (int)tracker.count);
        SWTDelayedObservableValueDecoratorTest.assertEquals((Object)this.oldValue, (Object)tracker.event.diff.getOldValue());
        SWTDelayedObservableValueDecoratorTest.assertEquals((Object)this.newValue, (Object)tracker.event.diff.getNewValue());
    }

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.SWTDelayedObservableValueDecoratorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.SWTDelayedObservableValueDecoratorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Shell shell;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.shell = new Shell();
        }

        public void tearDown() {
            this.shell.dispose();
            this.shell = null;
            super.tearDown();
        }

        public IObservableValue createObservableValue(Realm realm) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return SWTObservables.observeDelayedValue((int)0, (ISWTObservableValue)new SWTObservableValueDecorator((IObservableValue)new WritableValue(realm, null, (Object)clazz), (Widget)this.shell));
        }

        public Object getValueType(IObservableValue observable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }
    }
}

