/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class ScaleObservableValueMaxTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private Scale scale;
    private IObservableValue observable;
    static /* synthetic */ Class class$0;

    public ScaleObservableValueMaxTest() {
        this(null);
    }

    public ScaleObservableValueMaxTest(String testName) {
        super(testName, (IObservableContractDelegate)new Delegate());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.observable = (IObservableValue)this.getObservable();
        this.scale = this.delegate.scale;
    }

    protected IObservable doCreateObservable() {
        return this.getObservableContractDelegate().createObservable(SWTObservables.getRealm((Display)Display.getDefault()));
    }

    public void testGetValue() throws Exception {
        int max = 100;
        this.scale.setMaximum(max);
        ScaleObservableValueMaxTest.assertEquals((Object)new Integer(max), (Object)this.observable.getValue());
    }

    public void testSetValue() throws Exception {
        int max = 100;
        this.observable.setValue((Object)new Integer(max));
        ScaleObservableValueMaxTest.assertEquals((int)max, (int)this.scale.getMaximum());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.ScaleObservableValueMaxTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.toString());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.ScaleObservableValueMaxTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Scale scale;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.scale = new Scale((Composite)this.shell, 0);
            this.scale.setMaximum(1000);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.maximum().observe(realm, (Object)this.scale);
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object getValueType(IObservableValue observable) {
            return Integer.TYPE;
        }

        public Object createValue(IObservableValue observable) {
            return this.createIntegerValue(observable);
        }

        private Integer createIntegerValue(IObservableValue observable) {
            return new Integer((Integer)observable.getValue() + 1);
        }
    }
}

