/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ShellObservableValueTest
extends AbstractDefaultRealmTestCase {
    String oldValue;
    String newValue;
    Shell shell;
    IObservableValue observable;
    ValueChangeEventTracker tracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.observable = SWTObservables.observeText((Control)this.shell);
        this.oldValue = "old";
        this.newValue = "new";
        this.shell.setText(this.oldValue);
        this.tracker = ValueChangeEventTracker.observe((IObservableValue)this.observable);
    }

    public void tearDown() throws Exception {
        this.observable.dispose();
        this.observable = null;
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    public void testGetValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ShellObservableValueTest.assertEquals((Object)clazz, (Object)this.observable.getValueType());
    }

    public void testSetValue_FiresValueChangeEvent() {
        this.observable.setValue((Object)this.newValue);
        ShellObservableValueTest.assertEquals((int)1, (int)this.tracker.count);
        ShellObservableValueTest.assertEquals((Object)this.oldValue, (Object)this.tracker.event.diff.getOldValue());
        ShellObservableValueTest.assertEquals((Object)this.newValue, (Object)this.tracker.event.diff.getNewValue());
    }

    public void testSetValue_NullConvertedToEmptyString() {
        this.observable.setValue(null);
        ShellObservableValueTest.assertEquals((Object)"", (Object)this.observable.getValue());
        ShellObservableValueTest.assertEquals((String)"", (String)this.shell.getText());
    }

    public void testShellSetText_GetValueReturnsSame() {
        ShellObservableValueTest.assertEquals((Object)this.oldValue, (Object)this.observable.getValue());
        this.shell.setText(this.newValue);
        ShellObservableValueTest.assertEquals((Object)this.newValue, (Object)this.observable.getValue());
    }

    public void testShellSetText_NoValueChangeEvent() {
        this.shell.setText(this.newValue);
        ShellObservableValueTest.assertEquals((int)0, (int)this.tracker.count);
    }

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.ShellObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.toString());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.ShellObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Shell shell;
        int counter;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.shell = new Shell();
        }

        public void tearDown() {
            this.shell.dispose();
            this.shell = null;
            super.tearDown();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.text().observe(realm, (Object)this.shell);
        }

        public Object getValueType(IObservableValue observable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object createValue(IObservableValue observable) {
            return Integer.toString(this.counter++);
        }
    }
}

