/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerObservableValueSelectionTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private Spinner spinner;
    private IObservableValue observable;
    static /* synthetic */ Class class$0;

    public SpinnerObservableValueSelectionTest() {
        this(null);
    }

    public SpinnerObservableValueSelectionTest(String testName) {
        super(testName, (IObservableContractDelegate)new Delegate());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.observable = (IObservableValue)this.getObservable();
        this.spinner = this.delegate.spinner;
    }

    protected IObservable doCreateObservable() {
        return this.getObservableContractDelegate().createObservable(SWTObservables.getRealm((Display)Display.getDefault()));
    }

    public void testGetValue() throws Exception {
        int value = 100;
        this.spinner.setSelection(value);
        SpinnerObservableValueSelectionTest.assertEquals((Object)new Integer(value), (Object)this.observable.getValue());
    }

    public void testSetValue() throws Exception {
        int value = 100;
        this.observable.setValue((Object)new Integer(value));
        SpinnerObservableValueSelectionTest.assertEquals((int)value, (int)this.spinner.getSelection());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.SpinnerObservableValueSelectionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.toString());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.SpinnerObservableValueSelectionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Spinner spinner;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.spinner = new Spinner((Composite)this.shell, 0);
            this.spinner.setMaximum(1000);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.selection().observe(realm, (Object)this.spinner);
        }

        public void change(IObservable observable) {
            this.spinner.setSelection(this.createIntegerValue((IObservableValue)observable).intValue());
            this.spinner.notifyListeners(13, null);
        }

        public Object getValueType(IObservableValue observable) {
            return Integer.TYPE;
        }

        public Object createValue(IObservableValue observable) {
            return this.createIntegerValue(observable);
        }

        private Integer createIntegerValue(IObservableValue observable) {
            return new Integer((Integer)observable.getValue() + 1);
        }
    }
}

