/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.internal.databinding.swt.StyledTextTextProperty;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class StyledTextObservableValueTest
extends AbstractDefaultRealmTestCase {
    private StyledText text;
    private ValueChangeEventTracker listener;

    protected void setUp() throws Exception {
        super.setUp();
        Shell shell = new Shell();
        this.text = new StyledText((Composite)shell, 0);
        this.listener = new ValueChangeEventTracker();
    }

    public void testConstructorUpdateEventTypes() {
        try {
            new StyledTextTextProperty(new int[1]);
            new StyledTextTextProperty(new int[]{16});
            new StyledTextTextProperty(new int[]{24});
            new StyledTextTextProperty(new int[]{14});
            StyledTextObservableValueTest.assertTrue((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StyledTextObservableValueTest.fail();
        }
        try {
            new StyledTextTextProperty(new int[]{25});
            StyledTextObservableValueTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StyledTextObservableValueTest.assertTrue((boolean)true);
        }
    }

    public void testGetValueBeforeFocusOutChangeEventsFire() throws Exception {
        ISWTObservableValue observableValue = SWTObservables.observeText((Control)this.text, (int)16);
        observableValue.addValueChangeListener((IValueChangeListener)this.listener);
        String a = "a";
        String b = "b";
        this.text.setText(a);
        StyledTextObservableValueTest.assertEquals((Object)a, (Object)observableValue.getValue());
        StyledTextObservableValueTest.assertEquals((int)1, (int)this.listener.count);
        this.text.setText(b);
        this.text.notifyListeners(16, null);
        StyledTextObservableValueTest.assertEquals((int)2, (int)this.listener.count);
        StyledTextObservableValueTest.assertEquals((Object)a, (Object)this.listener.event.diff.getOldValue());
        StyledTextObservableValueTest.assertEquals((Object)b, (Object)this.listener.event.diff.getNewValue());
    }

    public void testDispose() throws Exception {
        ISWTObservableValue observableValue = SWTObservables.observeText((Control)this.text, (int)24);
        ValueChangeEventTracker testCounterValueChangeListener = new ValueChangeEventTracker();
        observableValue.addValueChangeListener((IValueChangeListener)testCounterValueChangeListener);
        String expected1 = "Test123";
        this.text.setText(expected1);
        StyledTextObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        StyledTextObservableValueTest.assertEquals((String)expected1, (String)this.text.getText());
        StyledTextObservableValueTest.assertEquals((Object)expected1, (Object)observableValue.getValue());
        observableValue.dispose();
        String expected2 = "NewValue123";
        this.text.setText(expected2);
        StyledTextObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        StyledTextObservableValueTest.assertEquals((String)expected2, (String)this.text.getText());
    }
}

