/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableSingleSelectionObservableValueTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private IObservableValue observable;
    private Table table;
    static /* synthetic */ Class class$0;

    public TableSingleSelectionObservableValueTest() {
        this(null);
    }

    public TableSingleSelectionObservableValueTest(String testName) {
        super(testName, (IObservableContractDelegate)new Delegate());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.observable = (IObservableValue)this.getObservable();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.table = this.delegate.table;
    }

    protected IObservable doCreateObservable() {
        Delegate delegate = (Delegate)this.getObservableContractDelegate();
        return delegate.createObservableValue(SWTObservables.getRealm((Display)Display.getDefault()));
    }

    public void testSetValue() throws Exception {
        TableSingleSelectionObservableValueTest.assertEquals((int)-1, (int)this.table.getSelectionIndex());
        TableSingleSelectionObservableValueTest.assertEquals((int)-1, (int)((Integer)this.observable.getValue()));
        Integer value = new Integer(0);
        this.observable.setValue((Object)value);
        TableSingleSelectionObservableValueTest.assertEquals((String)"table selection index", (int)value, (int)this.table.getSelectionIndex());
        TableSingleSelectionObservableValueTest.assertEquals((String)"observable value", (Object)value, (Object)this.observable.getValue());
    }

    public void testGetValue() throws Exception {
        int value = 1;
        this.table.setSelection(value);
        TableSingleSelectionObservableValueTest.assertEquals((String)"table selection index", (int)value, (int)this.table.getSelectionIndex());
        TableSingleSelectionObservableValueTest.assertEquals((String)"observable value", (Object)new Integer(value), (Object)this.observable.getValue());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.TableSingleSelectionObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.toString());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.tests.internal.databinding.swt.TableSingleSelectionObservableValueTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Table table;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.table = new Table((Composite)this.shell, 0);
            new TableItem(this.table, 0).setText("0");
            new TableItem(this.table, 0).setText("1");
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.singleSelectionIndex().observe(realm, (Object)this.table);
        }

        public Object getValueType(IObservableValue observable) {
            return Integer.TYPE;
        }

        public void change(IObservable observable) {
            int index = this.createIntegerValue((IObservableValue)observable);
            this.table.select(index);
            this.table.notifyListeners(13, null);
        }

        public Object createValue(IObservableValue observable) {
            return this.createIntegerValue(observable);
        }

        private Integer createIntegerValue(IObservableValue observable) {
            int value = (Integer)observable.getValue();
            switch (value) {
                case -1: 
                case 1: {
                    return new Integer(0);
                }
                case 0: {
                    return new Integer(1);
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }
}

