/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextObservableValueTest
extends AbstractDefaultRealmTestCase {
    private Text text;
    private ValueChangeEventTracker listener;

    protected void setUp() throws Exception {
        super.setUp();
        Shell shell = new Shell();
        this.text = new Text((Composite)shell, 0);
        this.listener = new ValueChangeEventTracker();
    }

    public void testConstructorUpdateEventTypes() {
        try {
            WidgetProperties.text((int)0);
            WidgetProperties.text((int)16);
            WidgetProperties.text((int)24);
            WidgetProperties.text((int)14);
            TextObservableValueTest.assertTrue((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TextObservableValueTest.fail();
        }
        try {
            WidgetProperties.text((int)25);
            TextObservableValueTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TextObservableValueTest.assertTrue((boolean)true);
        }
    }

    public void testGetValueBeforeFocusOutChangeEventsFire() throws Exception {
        IObservableValue observableValue = WidgetProperties.text((int)16).observe(Realm.getDefault(), (Object)this.text);
        observableValue.addValueChangeListener((IValueChangeListener)this.listener);
        String a = "a";
        String b = "b";
        this.text.setText(a);
        TextObservableValueTest.assertEquals((int)0, (int)this.listener.count);
        TextObservableValueTest.assertEquals((Object)a, (Object)observableValue.getValue());
        TextObservableValueTest.assertEquals((int)1, (int)this.listener.count);
        this.text.setText(b);
        TextObservableValueTest.assertEquals((int)1, (int)this.listener.count);
        this.text.notifyListeners(16, null);
        TextObservableValueTest.assertEquals((int)2, (int)this.listener.count);
        TextObservableValueTest.assertEquals((Object)a, (Object)this.listener.event.diff.getOldValue());
        TextObservableValueTest.assertEquals((Object)b, (Object)this.listener.event.diff.getNewValue());
    }

    public void testDispose() throws Exception {
        IObservableValue observableValue = WidgetProperties.text((int)24).observe(Realm.getDefault(), (Object)this.text);
        ValueChangeEventTracker testCounterValueChangeListener = new ValueChangeEventTracker();
        observableValue.addValueChangeListener((IValueChangeListener)testCounterValueChangeListener);
        String expected1 = "Test123";
        this.text.setText(expected1);
        TextObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        TextObservableValueTest.assertEquals((String)expected1, (String)this.text.getText());
        TextObservableValueTest.assertEquals((Object)expected1, (Object)observableValue.getValue());
        observableValue.dispose();
        String expected2 = "NewValue123";
        this.text.setText(expected2);
        TextObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        TextObservableValueTest.assertEquals((String)expected2, (String)this.text.getText());
    }
}

