/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Collections;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ObservableCollectionContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TableViewer viewer;
    ObservableListContentProvider contentProvider;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.viewer = new TableViewer((Composite)this.shell);
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
        this.viewer = null;
        super.tearDown();
    }

    public void testGetKnownElements_DisposedWithoutModificationOnContentProviderDispose() {
        WritableList input = new WritableList(Collections.singletonList("element"), null);
        this.contentProvider = new ObservableListContentProvider();
        this.contentProvider.inputChanged((Viewer)this.viewer, null, (Object)input);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        this.contentProvider.getElements((Object)input);
        ObservableCollectionContentProviderTest.assertEquals((int)1, (int)knownElements.size());
        DisposeEventTracker disposeTracker = DisposeEventTracker.observe((IObservable)knownElements);
        ChangeEventTracker changeTracker = ChangeEventTracker.observe((IObservable)knownElements);
        this.contentProvider.dispose();
        ObservableCollectionContentProviderTest.assertEquals((int)0, (int)changeTracker.count);
        ObservableCollectionContentProviderTest.assertEquals((int)1, (int)disposeTracker.count);
        ObservableCollectionContentProviderTest.assertTrue((boolean)knownElements.isDisposed());
    }
}

