/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SelectionProviderMultiSelectionObservableListTest
extends TestCase {
    private IPostSelectionProvider selectionProvider;
    private TableViewer viewer;
    private static String[] model = new String[]{"element0", "element1", "element2", "element3"};

    protected void setUp() throws Exception {
        Shell shell = new Shell();
        this.viewer = new TableViewer((Composite)shell, 2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)model);
        this.selectionProvider = this.viewer;
    }

    protected void tearDown() throws Exception {
        Shell shell = this.viewer.getTable().getShell();
        if (!shell.isDisposed()) {
            shell.dispose();
        }
    }

    public void testConstructorIllegalArgumentException() {
        try {
            ViewersObservables.observeMultiSelection(null);
            SelectionProviderMultiSelectionObservableListTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testAddRemove_NormalSelection() {
        this.doTestAddRemove(false);
    }

    public void testAddRemove_PostSelection() {
        this.doTestAddRemove(true);
    }

    private void doTestAddRemove(boolean postSelection) {
        IObservableList observable = postSelection ? ViewersObservables.observeMultiPostSelection((IPostSelectionProvider)this.selectionProvider) : ViewersObservables.observeMultiSelection((ISelectionProvider)this.selectionProvider);
        ListChangeEventTracker listener = ListChangeEventTracker.observe((IObservableList)observable);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)0, (int)observable.size());
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)model[0]));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)1, (int)listener.count);
        this.assertDiff(listener.event.diff, Collections.EMPTY_LIST, Collections.singletonList(model[0]));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)1, (int)observable.size());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)model[0], (Object)observable.get(0));
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)model[1]));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)2, (int)listener.count);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)2, (int)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Collections.singletonList(model[0]), Collections.singletonList(model[1]));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)1, (int)observable.size());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)model[1], (Object)observable.get(0));
        this.selectionProvider.setSelection((ISelection)new StructuredSelection(new Object[]{model[2], model[3]}));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)3, (int)listener.count);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)3, (int)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Collections.singletonList(model[1]), Arrays.asList(model[2], model[3]));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)2, (int)observable.size());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)model[2], (Object)observable.get(0));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)model[3], (Object)observable.get(1));
        this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)4, (int)listener.count);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)2, (int)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Arrays.asList(model[2], model[3]), Collections.EMPTY_LIST);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)0, (int)observable.size());
        observable.add((Object)model[1]);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)5, (int)listener.count);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)1, (int)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Collections.EMPTY_LIST, Collections.singletonList(model[1]));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)1, (int)((IStructuredSelection)this.viewer.getSelection()).size());
        observable.add(0, (Object)model[2]);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)6, (int)listener.count);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)1, (int)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Collections.singletonList(model[1]), Arrays.asList(model[1], model[2]));
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)2, (int)((IStructuredSelection)this.viewer.getSelection()).size());
        observable.clear();
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)7, (int)listener.count);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)2, (int)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Arrays.asList(model[1], model[2]), Collections.EMPTY_LIST);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        SelectionProviderMultiSelectionObservableListTest.assertEquals((int)0, (int)((IStructuredSelection)this.viewer.getSelection()).size());
    }

    private void assertDiff(ListDiff diff, List oldList, List newList) {
        oldList = new ArrayList(oldList);
        diff.applyTo(oldList);
        SelectionProviderMultiSelectionObservableListTest.assertEquals((String)"applying diff to list did not produce expected result", (Object)newList, oldList);
    }
}

