/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SelectionProviderSingleSelectionObservableValueTest
extends TestCase {
    private IPostSelectionProvider selectionProvider;
    private TableViewer viewer;
    private static String[] model = new String[]{"0", "1"};

    protected void setUp() throws Exception {
        Shell shell = new Shell();
        this.viewer = new TableViewer((Composite)shell, 0);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)model);
        this.selectionProvider = this.viewer;
    }

    protected void tearDown() throws Exception {
        Shell shell = this.viewer.getTable().getShell();
        if (!shell.isDisposed()) {
            shell.dispose();
        }
    }

    public void testConstructorIllegalArgumentException() {
        try {
            ViewersObservables.observeSingleSelection(null);
            SelectionProviderSingleSelectionObservableValueTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testSetValue() {
        IObservableValue observable = ViewersObservables.observeSingleSelection((ISelectionProvider)this.selectionProvider);
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        SelectionProviderSingleSelectionObservableValueTest.assertNull((Object)observable.getValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)0, (int)listener.count);
        observable.setValue((Object)model[0]);
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[0], (Object)SelectionProviderSingleSelectionObservableValueTest.getSelectedElement((ISelectionProvider)this.selectionProvider));
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[0], (Object)observable.getValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)1, (int)listener.count);
        observable.setValue((Object)model[1]);
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[1], (Object)SelectionProviderSingleSelectionObservableValueTest.getSelectedElement((ISelectionProvider)this.selectionProvider));
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[1], (Object)observable.getValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)2, (int)listener.count);
        observable.setValue(null);
        SelectionProviderSingleSelectionObservableValueTest.assertTrue((boolean)this.selectionProvider.getSelection().isEmpty());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)3, (int)listener.count);
    }

    public void testSelectionChangesTracked() {
        this.doTestSelectionChangesTracked(false);
    }

    public void testPostSelectionChangesTracked() {
        this.doTestSelectionChangesTracked(true);
    }

    private void doTestSelectionChangesTracked(boolean postSelection) {
        IObservableValue observable = postSelection ? ViewersObservables.observeSinglePostSelection((IPostSelectionProvider)this.selectionProvider) : ViewersObservables.observeSingleSelection((ISelectionProvider)this.selectionProvider);
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        SelectionProviderSingleSelectionObservableValueTest.assertNull((Object)observable.getValue());
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)model[0]));
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)1, (int)listener.count);
        SelectionProviderSingleSelectionObservableValueTest.assertNull((Object)listener.event.diff.getOldValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[0], (Object)listener.event.diff.getNewValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)observable, (Object)listener.event.getObservableValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[0], (Object)observable.getValue());
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)model[1]));
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)2, (int)listener.count);
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[0], (Object)listener.event.diff.getOldValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[1], (Object)listener.event.diff.getNewValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)observable, (Object)listener.event.getObservableValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[1], (Object)observable.getValue());
        this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)3, (int)listener.count);
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[1], (Object)listener.event.diff.getOldValue());
        SelectionProviderSingleSelectionObservableValueTest.assertNull((Object)listener.event.diff.getNewValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)observable, (Object)listener.event.getObservableValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals(null, (Object)observable.getValue());
    }

    public void testDispose() throws Exception {
        IObservableValue observable = ViewersObservables.observeSingleSelection((ISelectionProvider)this.selectionProvider);
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)model[0]));
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)1, (int)listener.count);
        SelectionProviderSingleSelectionObservableValueTest.assertNull((Object)listener.event.diff.getOldValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[0], (Object)listener.event.diff.getNewValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)observable, (Object)listener.event.getObservableValue());
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((Object)model[0], (Object)observable.getValue());
        observable.dispose();
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)model[1]));
        SelectionProviderSingleSelectionObservableValueTest.assertEquals((int)1, (int)listener.count);
    }

    private static Object getSelectedElement(ISelectionProvider selectionProvider) {
        return ((IStructuredSelection)selectionProvider.getSelection()).getFirstElement();
    }
}

