/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import junit.framework.TestCase;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementWrapper;
import org.eclipse.jface.viewers.IElementComparer;

public class ViewerElementWrapperTest
extends TestCase {
    private ViewerElementWrapper wrapper;
    private Object element;
    private IElementComparer comparer;

    protected void setUp() throws Exception {
        super.setUp();
        this.element = new ElementStub(0);
        this.comparer = new IdentityElementComparer();
        this.wrapper = new ViewerElementWrapper(this.element, this.comparer);
    }

    public void testConstructor_NullComparer() {
        try {
            new ViewerElementWrapper(this.element, null);
            ViewerElementWrapperTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void testEquals() {
        ViewerElementWrapperTest.assertFalse((boolean)this.wrapper.equals(null));
        ViewerElementWrapperTest.assertTrue((boolean)this.wrapper.equals((Object)this.wrapper));
        ViewerElementWrapperTest.assertTrue((boolean)this.wrapper.equals((Object)new ViewerElementWrapper(this.element, this.comparer)));
    }

    public void testHashCode() {
        int hash = 0;
        this.element = new ElementStub(hash);
        this.wrapper = new ViewerElementWrapper(this.element, this.comparer);
        ViewerElementWrapperTest.assertEquals((int)System.identityHashCode(this.element), (int)this.wrapper.hashCode());
        ViewerElementWrapperTest.assertEquals((int)hash, (int)this.element.hashCode());
    }

    static class ElementStub {
        private final int hash;

        public ElementStub(int hash) {
            this.hash = hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ElementStub that = (ElementStub)obj;
            return this.hash == that.hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class IdentityElementComparer
    implements IElementComparer {
        IdentityElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }

        public int hashCode(Object element) {
            return System.identityHashCode(element);
        }
    }
}

