/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;

public class HTML2TextReaderTest
extends TestCase {
    private static final boolean DEBUG = false;
    private static final String LD = System.getProperty("line.separator", "\n");
    static /* synthetic */ Class class$0;

    public HTML2TextReaderTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.tests.HTML2TextReaderTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    private void verify(String input, String expectedOutput, int styleRangeCount) throws IOException {
        StringReader reader = new StringReader(input);
        TextPresentation textPresentation = new TextPresentation();
        HTML2TextReader htmlReader = new HTML2TextReader((Reader)reader, textPresentation);
        String result = htmlReader.getString();
        HTML2TextReaderTest.assertEquals((String)expectedOutput, (String)result);
        Iterator styleRangeIterator = textPresentation.getAllStyleRangeIterator();
        ArrayList ranges = new ArrayList();
        while (styleRangeIterator.hasNext()) {
            ranges.add(styleRangeIterator.next());
        }
        HTML2TextReaderTest.assertEquals((String)"Incorrect number of style ranges", (int)styleRangeCount, (int)ranges.size());
        Collections.sort(ranges, new Comparator(){

            public int compare(Object o1, Object o2) {
                StyleRange range1 = (StyleRange)o1;
                StyleRange range2 = (StyleRange)o2;
                return range1.start - range2.start;
            }
        });
        int i = 0;
        while (i < ranges.size() - 1) {
            StyleRange range1 = (StyleRange)ranges.get(i);
            StyleRange range2 = (StyleRange)ranges.get(i + 1);
            if (range1.start + range1.length > range2.start) {
                HTML2TextReaderTest.assertTrue((String)"StyleRanges overlap", (boolean)false);
            }
            ++i;
        }
    }

    public void test0() throws IOException {
        String string = "<code>3<5<code>";
        String expected = "3<5";
        this.verify(string, expected, 0);
    }

    public void test1() throws IOException {
        String string = "<dl><dt>@author</dt><dd>Foo Bar</dd></dl>";
        String expected = String.valueOf(LD) + "@author" + LD + "\tFoo Bar" + LD;
        this.verify(string, expected, 1);
    }

    public void test2() throws IOException {
        String string = "<code>3>5<code>";
        String expected = "3>5";
        this.verify(string, expected, 0);
    }

    public void test3() throws IOException {
        String string = "<a href= \"<p>this is only a string - not a tag<p>\">text</a>";
        String expected = "text";
        this.verify(string, expected, 0);
    }

    public void test4() throws IOException {
        String string = "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1><h5>void p.Bb.fes()</h5><p><dl><dt>Parameters:</dt><dd><b>i</b> fred or <code>null</code></dd></dl></font></body></html>";
        String expected = "void p.Bb.fes()" + LD + LD + LD + "Parameters:" + LD + "\ti fred or null" + LD;
        this.verify(string, expected, 3);
    }

    public void test5() throws IOException {
        String string = "<code>1<2<3<4</code>";
        String expected = "1<2<3<4";
        this.verify(string, expected, 0);
    }

    public void test6() throws IOException {
        String string = "<p>Something.<p>Something more.";
        String expected = String.valueOf(LD) + "Something." + LD + "Something more.";
        this.verify(string, expected, 0);
    }

    public void testEntity1() throws IOException {
        String string = "&amp;";
        String expected = "&";
        this.verify(string, expected, 0);
    }

    public void testEntity2() throws IOException {
        String string = "&unknown;";
        String expected = "&unknown;";
        this.verify(string, expected, 0);
    }

    public void testBug367378() throws IOException {
        this.verify("<head>", "", 0);
        this.verify("<head>some styles</html>", "", 0);
        char[] cb = new char[20];
        StringReader reader = new StringReader("<head>");
        new HTML2TextReader((Reader)reader, null).read(cb);
        HTML2TextReaderTest.assertTrue((boolean)Arrays.equals(new char[20], cb));
    }

    public void testComments() throws Exception {
        String string = "<!-- begin-user-doc -->no comment<!-- end-user-doc -->";
        String expected = "no comment";
        this.verify(string, expected, 0);
    }

    public void testStyles1() throws IOException {
        String string = "<b>Hello World</b>";
        String expected = "Hello World";
        this.verify(string, expected, 1);
    }

    public void testStyles2() throws IOException {
        String string = "<del>Hello World</del>";
        String expected = "Hello World";
        this.verify(string, expected, 1);
    }

    public void testStyles3() throws IOException {
        String string = "<b><del>Hello World</del></b>";
        String expected = "Hello World";
        this.verify(string, expected, 1);
    }

    public void testStyles4() throws IOException {
        String string = "<del><b>Hello World</b></del>";
        String expected = "Hello World";
        this.verify(string, expected, 1);
    }

    public void testStyles5() throws IOException {
        String string = "<b>This <del> is a </del> test</b>";
        String expected = "This is a test";
        this.verify(string, expected, 3);
    }

    public void testStyles6() throws IOException {
        String string = "<del>This <b> is a </b> test</del>";
        String expected = "This is a test";
        this.verify(string, expected, 3);
    }

    public void testStyles7() throws IOException {
        String string = "<b>This<del>is a</del>test</b>";
        String expected = "Thisis atest";
        this.verify(string, expected, 3);
    }

    public void testStyles8() throws IOException {
        String string = "<del>This<b>is a</b>test</del>";
        String expected = "Thisis atest";
        this.verify(string, expected, 3);
    }

    public void testStyles9() throws IOException {
        String string = "<b>This <del>is <b>yet</b> another</del> test</b>";
        String expected = "This is yet another test";
        this.verify(string, expected, 3);
    }

    public void testStyles10() throws IOException {
        String string = "<del>This <b>is <del>yet</del> another </b>test</del>";
        String expected = "This is yet another test";
        this.verify(string, expected, 3);
    }
}

