/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.rules;

import junit.framework.TestCase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class FastPartitionerTest
extends TestCase {
    protected static final String COMMENT = "comment";
    protected static final String DEFAULT = "__dftl_partition_content_type";
    private IDocument fDoc;
    private IDocumentPartitioner fPartitioner;

    public void setUp() {
        this.fDoc = new Document();
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner(){
            {
                Token comment = new Token((Object)FastPartitionerTest.COMMENT);
                IPredicateRule[] rules = new IPredicateRule[]{new MultiLineRule("/*", "*/", (IToken)comment)};
                this.setPredicateRules(rules);
            }
        };
        this.fPartitioner = this.createPartitioner((IPartitionTokenScanner)scanner);
        this.fDoc.setDocumentPartitioner(this.fPartitioner);
        this.fPartitioner.connect(this.fDoc);
    }

    protected IDocumentPartitioner createPartitioner(IPartitionTokenScanner scanner) {
        return new FastPartitioner(scanner, new String[]{DEFAULT, COMMENT});
    }

    public void testGetPartition() {
        this.fDoc.set("docu     ment/* comment */docu     ment");
        int[] offsets = new int[]{13, 26};
        this.assertGetPartition_InterleavingPartitions(offsets);
    }

    public void testGetPartitionEmptyMiddle() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26, 39};
        this.assertGetPartition_InterleavingPartitions(offsets);
    }

    public void testGetPartitionEmptyStart() {
        this.fDoc.set("/* comment */docu     ment");
        int[] nArray = new int[2];
        nArray[1] = 13;
        int[] offsets = nArray;
        this.assertGetPartition_InterleavingPartitions(offsets);
    }

    public void testGetPartitionEmptyEnd() {
        this.fDoc.set("docu     ment/* comment */");
        int[] offsets = new int[]{13, 26};
        this.assertGetPartition_InterleavingPartitions(offsets);
    }

    public void testGetContentType() {
        this.fDoc.set("docu     ment/* comment */docu     ment");
        int[] offsets = new int[]{13, 26};
        this.assertGetContentType_InterleavingPartitions(offsets);
    }

    public void testGetContentTypeEmptyMiddle() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26, 39};
        this.assertGetContentType_InterleavingPartitions(offsets);
    }

    public void testGetContentTypeEmptyStart() {
        this.fDoc.set("/* comment */docu     ment");
        int[] nArray = new int[2];
        nArray[1] = 13;
        int[] offsets = nArray;
        this.assertGetContentType_InterleavingPartitions(offsets);
    }

    public void testGetContentTypeEmptyEnd() {
        this.fDoc.set("docu     ment/* comment */");
        int[] offsets = new int[]{13, 26};
        this.assertGetContentType_InterleavingPartitions(offsets);
    }

    public void testComputePartitioning() {
        this.fDoc.set("docu     ment/* comment */docu     ment");
        int[] offsets = new int[]{13, 26};
        this.assertComputePartitioning_InterleavingPartitions(offsets);
    }

    public void testComputePartitioningEmptyMiddle() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26, 39};
        this.assertComputePartitioning_InterleavingPartitions(offsets);
    }

    public void testComputePartitioningEmptyStart() {
        this.fDoc.set("/* comment */docu     ment");
        int[] nArray = new int[2];
        nArray[1] = 13;
        int[] offsets = nArray;
        this.assertComputePartitioning_InterleavingPartitions(offsets);
    }

    public void testComputePartitioningEmptyEnd() {
        this.fDoc.set("docu     ment/* comment */");
        int[] offsets = new int[]{13, 26};
        this.assertComputePartitioning_InterleavingPartitions(offsets);
    }

    public void testComputePartitioningSubrangeBeforeBoundaries() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26};
        this.assertComputePartitioning_InterleavingPartitions(12, 38, offsets, DEFAULT);
    }

    public void testComputePartitioningSubrangeOnBoundaries() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26, 39};
        this.assertComputePartitioning_InterleavingPartitions(13, 39, offsets, DEFAULT);
    }

    public void testComputePartitioningSubrangeOnBoundaries2() {
        this.fDoc.set("/* comment *//* comment *//* comment */");
        int[] offsets = new int[]{13, 26};
        this.assertComputePartitioning_InterleavingPartitions(13, 26, offsets, DEFAULT);
    }

    public void testComputePartitioningSubrangeAfterBoundaries() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{26, 26, 39};
        this.assertComputePartitioning_InterleavingPartitions(14, 40, offsets, COMMENT);
    }

    public void testComputePartitioningSubrangeInBoundaries1() {
        this.fDoc.set("/* comment */");
        int[] offsets = new int[]{};
        this.assertComputePartitioning_InterleavingPartitions(1, 12, offsets, COMMENT);
    }

    public void testComputePartitioningSubrangeInBoundaries2() {
        this.fDoc.set("docu     ment");
        int[] offsets = new int[]{};
        this.assertComputePartitioning_InterleavingPartitions(1, 12, offsets, DEFAULT);
    }

    public void testPR101014() throws BadLocationException {
        this.fDoc.set("package pr101014;\n\nclass X {\nString s= \n\t/*foo*/;\n}\n");
        int[] offsets = new int[]{41, 48};
        this.assertComputePartitioning_InterleavingPartitions(offsets);
        this.fDoc.replace(40, 8, "\t/*foo*/");
        this.assertComputePartitioning_InterleavingPartitions(offsets);
    }

    public void testPR130900() throws Exception {
        this.fPartitioner.disconnect();
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner(){
            {
                Token comment = new Token((Object)FastPartitionerTest.COMMENT);
                IPredicateRule[] rules = new IPredicateRule[]{new SingleLineRule("#", null, (IToken)comment, '\u0000', true, false)};
                this.setPredicateRules(rules);
            }
        };
        this.fPartitioner = this.createPartitioner((IPartitionTokenScanner)scanner);
        this.fDoc.setDocumentPartitioner(this.fPartitioner);
        this.fPartitioner.connect(this.fDoc);
        this.fDoc.set("#");
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] offsets = nArray;
        this.assertComputePartitioning_InterleavingPartitions(offsets);
    }

    public void testBug368219_1() throws Exception {
        this.fPartitioner.disconnect();
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner(){
            {
                Token comment = new Token((Object)FastPartitionerTest.COMMENT);
                IPredicateRule[] rules = new IPredicateRule[]{new MultiLineRule("/*", "*/", (IToken)comment)};
                this.setPredicateRules(rules);
            }
        };
        this.fPartitioner = this.createPartitioner((IPartitionTokenScanner)scanner);
        this.fDoc.setDocumentPartitioner(this.fPartitioner);
        this.fPartitioner.connect(this.fDoc);
        this.fDoc.set("/**");
        this.assertEqualPartition(0, 3, DEFAULT);
    }

    public void testBug368219_2() throws Exception {
        this.fPartitioner.disconnect();
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner(){
            {
                Token comment = new Token((Object)FastPartitionerTest.COMMENT);
                IPredicateRule[] rules = new IPredicateRule[]{new MultiLineRule("/*", "*/", (IToken)comment, '\u0000', true)};
                this.setPredicateRules(rules);
            }
        };
        this.fPartitioner = this.createPartitioner((IPartitionTokenScanner)scanner);
        this.fDoc.setDocumentPartitioner(this.fPartitioner);
        this.fPartitioner.connect(this.fDoc);
        this.fDoc.set("/**");
        this.assertEqualPartition(0, 3, COMMENT);
    }

    public void testBug409538_1() throws Exception {
        this.fPartitioner.disconnect();
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner(){
            {
                Token comment = new Token((Object)FastPartitionerTest.COMMENT);
                IPredicateRule[] rules = new IPredicateRule[]{new MultiLineRule("<!--", "-->", (IToken)comment, '\u0000', true)};
                this.setPredicateRules(rules);
            }
        };
        this.fPartitioner = this.createPartitioner((IPartitionTokenScanner)scanner);
        this.fDoc.setDocumentPartitioner(this.fPartitioner);
        this.fPartitioner.connect(this.fDoc);
        this.fDoc.set("<");
        this.assertEqualPartition(0, 1, DEFAULT);
    }

    public void testBug409538_2() throws Exception {
        this.fPartitioner.disconnect();
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner(){
            {
                Token comment = new Token((Object)FastPartitionerTest.COMMENT);
                IPredicateRule[] rules = new IPredicateRule[]{new MultiLineRule("<!--", "-->", (IToken)comment, '\u0000', true)};
                this.setPredicateRules(rules);
            }
        };
        this.fPartitioner = this.createPartitioner((IPartitionTokenScanner)scanner);
        this.fDoc.setDocumentPartitioner(this.fPartitioner);
        this.fPartitioner.connect(this.fDoc);
        this.fDoc.set("<!-- blah");
        this.assertEqualPartition(0, 9, COMMENT);
    }

    private void assertComputePartitioning_InterleavingPartitions(int[] offsets) {
        this.assertComputePartitioning_InterleavingPartitions(0, this.fDoc.getLength(), offsets, DEFAULT);
    }

    private void assertComputePartitioning_InterleavingPartitions(int startOffset, int endOffset, int[] offsets, String startType) {
        ITypedRegion[] regions = this.fPartitioner.computePartitioning(startOffset, endOffset - startOffset);
        String type = startType;
        int previousOffset = startOffset;
        int j = 0;
        int i = 0;
        while (i <= offsets.length) {
            int currentOffset;
            int n = currentOffset = i == offsets.length ? endOffset : offsets[i];
            if (currentOffset - previousOffset != 0) {
                ITypedRegion region = regions[j++];
                this.assertTypedRegion(region, previousOffset, currentOffset, type);
            }
            type = type == DEFAULT ? COMMENT : DEFAULT;
            previousOffset = currentOffset;
            ++i;
        }
    }

    private void assertGetContentType_InterleavingPartitions(int[] offsets) {
        String type = DEFAULT;
        int previousOffset = 0;
        int i = 0;
        while (i <= offsets.length) {
            int offset = i == offsets.length ? this.fDoc.getLength() : offsets[i];
            this.assertEqualPartitionType(previousOffset, offset, type);
            type = type == DEFAULT ? COMMENT : DEFAULT;
            previousOffset = offset;
            ++i;
        }
    }

    private void assertGetPartition_InterleavingPartitions(int[] offsets) {
        String type = DEFAULT;
        int previousOffset = 0;
        int i = 0;
        while (i <= offsets.length) {
            int offset = i == offsets.length ? this.fDoc.getLength() : offsets[i];
            this.assertEqualPartition(previousOffset, offset, type);
            type = type == DEFAULT ? COMMENT : DEFAULT;
            previousOffset = offset;
            ++i;
        }
    }

    private void assertEqualPartition(int offset, int end, String type) {
        int from = offset;
        int to = end - 1;
        int i = from;
        while (i <= to) {
            ITypedRegion region = this.fPartitioner.getPartition(i);
            this.assertTypedRegion(region, offset, end, type);
            ++i;
        }
    }

    private void assertTypedRegion(ITypedRegion region, int offset, int end, String type) {
        FastPartitionerTest.assertEquals((int)offset, (int)region.getOffset());
        FastPartitionerTest.assertEquals((int)(end - offset), (int)region.getLength());
        FastPartitionerTest.assertEquals((String)type, (String)region.getType());
    }

    private void assertEqualPartitionType(int offset, int end, String type) {
        int from = offset;
        int to = end - 1;
        int i = from;
        while (i <= to) {
            FastPartitionerTest.assertEquals((String)type, (String)this.fPartitioner.getContentType(i));
            ++i;
        }
    }
}

