/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.core.text.plugin.XMLTextChangeListener;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractDSModelTestCase
extends TestCase {
    protected static final String LF = "\n";
    protected static final String CR = "\r";
    protected static final String CRLF = "\r\n";
    public static final String COMPONENT_NAME = "sample";
    protected Document fDocument;
    protected DSModel fModel;
    protected IModelTextChangeListener fListener;

    protected void setUp() throws Exception {
        this.fDocument = new Document();
    }

    protected void load() {
        this.load(false);
    }

    protected void load(boolean addListener) {
        try {
            this.fModel = new DSModel((IDocument)this.fDocument, false);
            this.fModel.load();
            if (!this.fModel.isLoaded() || !this.fModel.isValid()) {
                AbstractDSModelTestCase.fail((String)"model cannot be loaded");
            }
            if (addListener) {
                this.fListener = new XMLTextChangeListener(this.fModel.getDocument());
                this.fModel.addModelChangedListener((IModelChangedListener)this.fListener);
            }
        }
        catch (CoreException coreException) {
            AbstractDSModelTestCase.fail((String)"model cannot be loaded");
        }
    }

    protected void setXMLContents(StringBuffer body, String newline) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append(newline);
        sb.append("<scr:component xmlns:scr=\"http://www.osgi.org/xmlns/scr/v1.1.0\" name=\"sample\">");
        sb.append(newline);
        if (body != null) {
            sb.append(body.toString());
        }
        sb.append(newline);
        sb.append("</scr:component>");
        sb.append(newline);
        this.fDocument.set(sb.toString());
    }

    protected void reload() {
        TextEdit[] ops = this.fListener.getTextOperations();
        if (ops.length == 0) {
            return;
        }
        MultiTextEdit multi = new MultiTextEdit();
        multi.addChildren(ops);
        try {
            multi.apply((IDocument)this.fDocument);
        }
        catch (MalformedTreeException e) {
            AbstractDSModelTestCase.fail((String)e.getMessage());
        }
        catch (BadLocationException e) {
            AbstractDSModelTestCase.fail((String)e.getMessage());
        }
        this.load();
    }
}

