/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;

public class DSPropertiesTestCase
extends AbstractDSModelTestCase {
    public void testAddPropertiesComponent() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties\">");
        buffer.append("</properties>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSPropertiesTestCase.assertNotNull((Object)component);
        IDSProperties[] propertiesElements = component.getPropertiesElements();
        DSPropertiesTestCase.assertTrue((propertiesElements.length == 1 ? 1 : 0) != 0);
        IDSProperties properties = propertiesElements[0];
        String entry = properties.getEntry();
        DSPropertiesTestCase.assertTrue((boolean)entry.equals("OSGI-INF/vendor.properties"));
        DSPropertiesTestCase.assertEquals((String)entry, (String)properties.getName());
    }

    public void testMultipleProperties() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties1\">");
        buffer.append("</properties>");
        buffer.append("\n");
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties2\">");
        buffer.append("</properties>");
        buffer.append("\n");
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties3\">");
        buffer.append("</properties>");
        buffer.append("\n");
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties4\">");
        buffer.append("</properties>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        IDSProperties[] propertiesElements = component.getPropertiesElements();
        DSPropertiesTestCase.assertTrue((propertiesElements.length == 4 ? 1 : 0) != 0);
        int i = 0;
        while (i < 4) {
            IDSProperties properties = propertiesElements[i];
            String entry = properties.getEntry();
            DSPropertiesTestCase.assertTrue((boolean)entry.equals("OSGI-INF/vendor.properties" + (i + 1)));
            ++i;
        }
    }

    public void testDefaultValuesService() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<properties>");
        buffer.append("\n");
        buffer.append("</properties>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSPropertiesTestCase.assertNotNull((Object)component);
        IDSProperties[] propertiesElements = component.getPropertiesElements();
        DSPropertiesTestCase.assertTrue((propertiesElements.length == 1 ? 1 : 0) != 0);
        IDSProperties properties = propertiesElements[0];
        DSPropertiesTestCase.assertTrue((properties.getEntry() == null ? 1 : 0) != 0);
    }

    public void testAddPropertiesFactory() {
        StringBuffer buffer = new StringBuffer();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSProperties Properties = factory.createProperties();
        String entry = "OSGI-INF/vendor.propertiesFactory";
        Properties.setEntry(entry);
        IDSComponent component = this.fModel.getDSComponent();
        component.addPropertiesElement(Properties);
        String content = component.toString();
        DSPropertiesTestCase.assertTrue((content.indexOf("entry=\"" + entry + "\"") != -1 ? 1 : 0) != 0);
        IDSProperties[] PropertiesElements = component.getPropertiesElements();
        IDSProperties Properties0 = PropertiesElements[0];
        DSPropertiesTestCase.assertNotNull((Object)Properties0);
        DSPropertiesTestCase.assertTrue((boolean)Properties0.getEntry().equals(entry));
    }
}

